% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variograms.R
\name{setCgram}
\alias{setCgram}
\alias{vg.Exp}
\alias{vg.exp}
\alias{vg.Exponential}
\alias{vg.Gau}
\alias{vg.gauss}
\alias{vg.Gauss}
\alias{vg.Sph}
\alias{vg.sph}
\alias{vg.Spherical}
\alias{gsi.validModels}
\title{Generate D-variate variogram models}
\usage{
setCgram(type, nugget = sill * 0, sill, anisRanges, extraPar = 0)
}
\arguments{
\item{type}{model of correlation function. The function expects a constant, e.g. the internal constants 'vg.Gau' for Gaussian model or 'vg.Exp'. for exponential models. See examples for usage.}

\item{nugget}{(DxD)-matrix for the nugget effect. Default is a muted nugget (0).}

\item{sill}{(DxD)-matrix for the partial sills of the correlation function}

\item{anisRanges}{2x2 or 3x3 matrix of ranges (see details)}

\item{extraPar}{for certain correlation functions, extra parameters (smoothness, period, etc)}
}
\value{
an object of class "gmCgram" containing the linear model of corregionalization
of the nugget and the structure given.
}
\description{
Function to set up D-variate variogram models based on model type, the variogram parameters sill and nugget and a matrix describing the anisotropy of the range.
}
\details{
The argument \code{type} must be an integer indicating the model to be used.
Some constants are available to make reading code more understandable. That is, you can
either write \code{1}, \code{vg.sph}, \code{vg.Sph} or \code{vg.Spherical}, they will all work and produce
a spherical model. The same applies for the following models:
\code{vg.Gauss = vg.Gau = vg.gau = 0};
\verb{vg.Exponential = vg.Exp = vg. exp = 2}.
These constants are available after calling \code{data("variogramModels")}.
No other model is currently available, but this data object will be
regularly updated.
The constant vector \code{gsi.validModels} contains all currently valid models.

Argument \code{anisRange} expects a matrix $M$ such that
\deqn{
h^2 = (\mathbf{x}_i-\mathbf{x}_j)\cdot M^{-1}\cdot (\mathbf{x}_i-\mathbf{x}_j)^t
}
is the (square of) the lag distance to be fed into the correlation function.
}
\examples{
utils::data("variogramModels") # shortcut for all model constants
v1 = setCgram(type=vg.Gau, sill=diag(2), anisRanges = 3*diag(c(3,1)))
v2 = setCgram(type=vg.Exp, sill=0.3*diag(2), anisRanges = 0.5*diag(2))
vm = v1+v2
plot(vm)
}
\concept{gmCgram}
