% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.R
\name{gsi.gstatCokriging2compo}
\alias{gsi.gstatCokriging2compo}
\alias{gsi.gstatCokriging2rmult}
\alias{gsi.gstatCokriging2compo.default}
\alias{gsi.gstatCokriging2compo.data.frame}
\alias{gsi.gstatCokriging2rmult.default}
\alias{gsi.gstatCokriging2rmult.data.frame}
\title{Reorganisation of cokriged compositions}
\usage{
gsi.gstatCokriging2compo(COKresult, ...)

\method{gsi.gstatCokriging2compo}{default}(COKresult, ...)

\method{gsi.gstatCokriging2compo}{data.frame}(
  COKresult,
  V = NULL,
  orignames = NULL,
  tol = 1e-12,
  nscore = FALSE,
  gg = NULL,
  ...
)

\method{gsi.gstatCokriging2rmult}{default}(COKresult, ...)

\method{gsi.gstatCokriging2rmult}{data.frame}(COKresult, nscore = FALSE, gg = NULL, ...)
}
\arguments{
\item{COKresult}{output of a \code{\link[gstat:predict.gstat]{gstat::predict.gstat()}} cokriging,
typically of class "data.frame", \code{\link[sp:SpatialPoints]{sp::SpatialPointsDataFrame()}},
\code{\link[sp:SpatialGridDataFrame]{sp::SpatialGridDataFrame()}} or \code{\link[sp:SpatialGridDataFrame]{sp::SpatialPixelsDataFrame()}}}

\item{...}{further arguments needed for nscore (\strong{deprecated})}

\item{V}{string or matrix describing which logratio was applied ("ilr", "alr",
or a matrix computing the ilr corrdinates; clr is not allowed!)}

\item{orignames}{names of the original components (optional, but recommended)}

\item{tol}{for generalized inversion of the matrix (\strong{rarely touched!})}

\item{nscore}{boolean, were the data normal score-transformed? (\strong{deprecated})}

\item{gg}{in the case that normal score transformation was applied, provide the gstat object! (\strong{deprecated})}
}
\value{
an (N,D)-object of class \code{c("spatialGridAcomp","acomp")}
with the predictions, together with an extra attribute "krigVar"
containing the cokriging covariance matrices  in an (N, D, D)-array; here N=number of
interpolated locations, D=number of original components of the composition
}
\description{
Produce compositional predictions out of a \code{\link[gstat:gstat]{gstat::gstat()}} prediction
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Reorganisation of cokriged compositions

\item \code{data.frame}: Reorganisation of cokriged compositions

\item \code{default}: Reorganisation of cokriged multivariate data

\item \code{data.frame}: Reorganisation of cokriged multivariate data
}}

\seealso{
\code{\link[=image_cokriged.spatialGridRmult]{image_cokriged.spatialGridRmult()}} for an example
}
