% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmAnisotropy.R
\name{as.AnisotropyScaling}
\alias{as.AnisotropyScaling}
\alias{as.AnisotropyScaling.AnisotropyScaling}
\alias{as.AnisotropyScaling.numeric}
\title{Convert to anisotropy scaling matrix}
\usage{
as.AnisotropyScaling(x)

\method{as.AnisotropyScaling}{AnisotropyScaling}(x)

\method{as.AnisotropyScaling}{numeric}(x)
}
\arguments{
\item{x}{an object convertible to an anisotropy scaling matrix; see details}
}
\value{
A matrix \eqn{A} such that for any lag vector \eqn{h}, the variogram model turns
isotropic in terms of \eqn{u=A\cdot h}.
}
\description{
Convert an anisotropy specification to a scaling matrix
}
\details{
Method \code{as.AnisotropyScaling.numeric()} expects a vector of two numbers in 2D,
or a vector of 5 numbers in 3D. These are in 2D, the azimuth of maximum continuity (in
degrees, clockwise from North) and the anisotropy ratio of short/long range. In 3D
these are: 1,2) the azimuth and the dip of the direction of maximal continuity; 3) the
angle of rotation around the axis of the first direction; 4,5) the anisotropy ratios of
the ranges of the second/first and third/first directions of maximal continuity. All angles
are given in degrees, all ratios must be smaller or equal to 1.
}
\section{Methods (by class)}{
\itemize{
\item \code{AnisotropyScaling}: Convert to anisotropy scaling matrix

\item \code{numeric}: Convert to anisotropy scaling matrix
}}

\examples{
as.AnisotropyScaling(c(30,0.5))
}
