% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.R
\name{setGridOrder}
\alias{setGridOrder}
\alias{getGridOrder}
\alias{setGridOrder_sp}
\alias{setGridOrder_array}
\alias{gridOrder_sp}
\alias{gridOrder_gstat}
\alias{gridOrder_array}
\alias{gridOrder_GSLib}
\title{Set or get the ordering of a grid}
\usage{
setGridOrder(x, refpoint, cycle)

setGridOrder_sp(x, G = 2)

setGridOrder_array(x, G = 2)

gridOrder_sp(G = 2)

gridOrder_gstat(G = 2)

gridOrder_array(G = 2)

gridOrder_GSLib(G = 2)
}
\arguments{
\item{x}{a data container for the elements of the grid; the grid order is stored as an attribute to it}

\item{refpoint}{a string specifying which point of the grid corresponds
to the first element of \code{x}; see below}

\item{cycle}{a permutation of the integers \code{1:G} (see below)}

\item{G}{number of geographic dimensions of the setting, typically \code{G=2} or \code{G=3}}
}
\value{
\code{setGridOrder(x,...)} returns the object \code{x} with the grid order description attached
as an attribute "gridOrder"; \code{getGridOrder(x)} retrieves this attribute and returns it.
}
\description{
Specify or retrieve the ordering in which a grid is stored in a vector (or matrix).
}
\details{
A "gridOrder" attribute is a list consisting of two named elements:
\describe{
\item{refpoint}{one of  "topleft", "bottomleft", "topright" or "bottomright" in 2D, or
also of "topleftsurf", "bottomleftsurf", "toprightsurf", "bottomrightsurf", "topleftdeep","bottomleftdeep",
"toprightdeep" or "bottomrightdeep" in 3D ("deep" is accessory, i.e.  "topleft"== "topleftdeep"),
indicating the location on the grid of the first point of the object \code{x}}
\item{cycle}{a permutation of \code{1:G} indicating in which order run the dymensions, from faster to slower}
}

Thus, a conventional ordering of a (nX*nY)-element vector into a matrix to plot with \code{\link[graphics:image]{graphics::image()}}
corresponds to an \code{refpoint="bottomleft"} and \code{cycle=1:2}, i.e. start with the lower left corner
and run first by rows (eastwards), then by columns (northwards). This  is constructed by
\code{gridOrder_array(G)}, and can be directly set to an object \code{x} by \code{setGridOrder_array(x,G)};
\code{gridOrder_GSLib} is an alias for \code{gridOrder_array}.

The grids from package "sp" (and many other in R), on the contrary follow the convention
\code{refpoint="topleft"} and \code{cycle=1:2},  i.e. start with the upper left corner
and run first by rows (eastwards), then by columns (\strong{southwards}).  This  is constructed by
\code{gridOrder_sp(G)}, and can be directly set to an object \code{x} by \code{setGridOrder_sp(x,G)}; \code{gridOrder_gstat}
is an alias for \code{gridOrder_sp}.
}
\section{Functions}{
\itemize{
\item \code{setGridOrder_sp}: Set or get the ordering of a grid

\item \code{setGridOrder_array}: Set or get the ordering of a grid

\item \code{gridOrder_sp}: Set or get the ordering of a grid

\item \code{gridOrder_gstat}: Set or get the ordering of a grid

\item \code{gridOrder_array}: Set or get the ordering of a grid

\item \code{gridOrder_GSLib}: Set or get the ordering of a grid
}}

\examples{
gt = sp::GridTopology(cellcentre.offset=c(1,11), cellsize=c(1,1), cells.dim=c(5,3))
sp::coordinates(sp::SpatialGrid(grid=gt))
gridOrder_sp(2)
}
\seealso{
\code{\link[=sortDataInGrid]{sortDataInGrid()}} for ways of reordering a grid
}
