% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploratools.R
\name{pwlrmap}
\alias{pwlrmap}
\title{Compositional maps, pairwise logratios
Matrix of maps showing different combinations of components of a composition, in pairwise logratios}
\usage{
pwlrmap(
  loc,
  comp,
  colscale = rev(rainbow(10, start = 0, end = 4/6)),
  cexrange = c(0.1, 2),
  scale = rank,
  commonscale = FALSE,
  foregroundcolor = "black",
  closeplot = TRUE
)
}
\arguments{
\item{loc}{matrix or data.frame of coordinates of the sample locations}

\item{comp}{composition observed at every location, can be a matrix, a data.frame or
of one of the classes \code{compositions::acomp} or \code{compositions::aplus}}

\item{colscale}{set of colors to be used as colorscale (defauls to 10 colors between blue and red)}

\item{cexrange}{symbol size min and max values (default to 0.1 to 2)}

\item{scale}{function scaling the set of z-values of each map, defaults to \code{\link{rank}}}

\item{commonscale}{logical, should all plots share a common z-scale? defaults to FALSE}

\item{foregroundcolor}{color to be used for the border of the symbol}

\item{closeplot}{logical, should the plot be left open (FALSE) for further changes, or be frozen (TRUE)?
defaults to TRUE}
}
\value{
The function is primarily called for producing a matrix of (D,D) plots of the D-part
compositional samples, where at each plot we represent a map whose symbols are colored and
sized according to a z-scale controlled by a different logratio. For each plot, this is the
logratio of the row variable by the column variable. However, in case that \code{closeplot=FALSE},
this function returns
invisibly the graphical parameters that were active prior to calling this function. This allows
the user to add further stuff to the plots (mostly, using \code{par(mfg=c(i,j))} to plot on the
diagram (i,j)), or manually freeze the plot (by wrapping the call to \code{pwlrmap} on a call to
\code{\link{par}}).
}
\description{
Compositional maps, pairwise logratios
Matrix of maps showing different combinations of components of a composition, in pairwise logratios
}
\examples{

data("Windarling")
coords = as.matrix(Windarling[,c("Easting","Northing")])
compo = Windarling[,c("Fe","Al2O3","SiO2", "Mn", "P")]
compo$Rest = 100-rowSums(compo)
compo = compositions::acomp(compo) 
# in quantiles (default, ranking controls color and size)
pwlrmap(coords, compo) 
\donttest{
# in logratios (I=identity)
pwlrmap(coords, compo, scale=I)
# in ratios (i.e., apply exp)
pwlrmap(coords, compo, scale=exp)  
# use only color, no change in symbol size
pwlrmap(coords, compo, cexrange=c(1,1)) 
# change all
pwlrmap(coords, compo, commonscale=TRUE, cexrange=c(1.2,1.2), 
                    colscale=rev(rainbow(40, start=0, end=4/6))) 
}
}
