% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmValidationStrategy.R
\name{validate}
\alias{validate}
\alias{validate.LeaveOneOut}
\alias{validate.NfoldCrossValidation}
\title{Validate a spatial model}
\usage{
validate(object, strategy, ...)

\method{validate}{LeaveOneOut}(object, strategy, ...)

\method{validate}{NfoldCrossValidation}(object, strategy, ...)
}
\arguments{
\item{object}{spatial model object, typically of class \code{\link[gstat:gstat]{gstat::gstat()}} or \linkS4class{gmSpatialModel}}

\item{strategy}{which strategy to follow for the validation? see functions in 'see also' below.}

\item{...}{generic parameters, ignored.}
}
\value{
A data frame of predictions (possibly with kriging variances and covariances, or equivalent
uncertainty measures) for each element of the validation set
}
\description{
Validate a spatial model by predicting some values. Typically this will be a validation set,
or else some subset of the conditing data.
}
\section{Methods (by class)}{
\itemize{
\item \code{LeaveOneOut}: Validate a spatial model

\item \code{NfoldCrossValidation}: Validate a spatial model
}}

\examples{
data("Windarling")
X = Windarling[,c("Easting","Northing")]
Z = compositions::acomp(Windarling[,c(9:12,16)])
gm = make.gmCompositionalGaussianSpatialModel(data=Z, coords=X)
vg = variogram(gm)
md = gstat::vgm(range=30, model="Sph", nugget=1, psill=1)
gs = fit_lmc(v=vg, g=gm, model=md) 
\dontrun{ v1 = validate(gs, strategy=LeaveOneOut()) # quite slow }
vs2 = NfoldCrossValidation(nfolds=sample(1:10, nrow(X), replace=TRUE))
vs2
\dontrun{ v2 = validate(gs, strategy=vs2) # quite slow }
}
\seealso{
Other validation functions: 
\code{\link{LeaveOneOut}},
\code{\link{NfoldCrossValidation}}

Other accuracy functions: 
\code{\link{accuracy}()},
\code{\link{mean.accuracy}()},
\code{\link{plot.accuracy}()},
\code{\link{precision}()},
\code{\link{xvErrorMeasures}()}
}
\concept{accuracy functions}
\concept{validation functions}
