% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variograms.R
\name{[.gmCgram}
\alias{[.gmCgram}
\title{Subsetting of gmCgram variogram structures}
\usage{
\method{[}{gmCgram}(x, i, j = i, ...)
}
\arguments{
\item{x}{\code{gmCgram} variogram object}

\item{i}{row-indices of the variables to be kept/removed}

\item{j}{column-indices of the variables to be kept/removed (if only \code{i}
is specified, \code{j} will be taken as equal to \code{i}!)}

\item{...}{extra arguments for generic functionality}
}
\value{
a \code{gmCgram} variogram object with the desired variables only.
}
\description{
Extraction of some variables of a gmCgram object
}
\details{
This function can be used to extract the model for a a subset of variables.
If only \code{i} is specified, \code{j} will be taken as equal to \code{i}.
If you want to select all \code{i}'s for certain \code{j}'s or vice versa, give
\code{i=1:dim(x$nugget)[1]} and \code{j=} your desired indices, respectively
\code{j=1:dim(x$nugget)[2]} and \code{i=} your desired indices; replace \code{x} by the
object you are giving. If \code{i!=j}, the output will be a \code{c("gmXCgram","gmCgram")}
object, otherwise it will be a regular class \code{"gmCgram"} object.
If you want to extract "slots" or
"elements" of the variogram, use the $-notation. If you want to extract variables of the
variogram matrices, use the \code{[}-notation.
}
\examples{
utils::data("variogramModels")
v1 = setCgram(type=vg.Gau, sill=diag(2), anisRanges = 3*diag(c(3,1)))
v2 = setCgram(type=vg.Exp, sill=0.3*diag(2), anisRanges = 0.5*diag(2))
vm = v1+v2
vm[1,1]
}
\seealso{
Other gmCgram functions: 
\code{\link{[[.gmCgram}()},
\code{\link{as.function.gmCgram}()},
\code{\link{as.gmCgram.variogramModelList}()},
\code{\link{length.gmCgram}()},
\code{\link{ndirections}()},
\code{\link{plot.gmCgram}()},
\code{\link{variogramModelPlot}()}
}
\concept{gmCgram functions}
