% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key.R
\name{Key}
\alias{Key}
\title{Create \code{Key} Object}
\usage{
Key(key, bar = NULL, to = NULL, scope = NULL)
}
\arguments{
\item{key}{An integer between -7 and 7, which indicates the number of
flat or sharp symbols in the key signature.}

\item{bar}{Optional. A positive integer which indicates the number of
the measure into which to insert the \code{Key} object. By default, a \code{Key}
object will be inserted into the first measure(s).}

\item{to}{Optional. A positive integer or a single character which
indicates the \code{Line} object to which to add the \code{Key} object. By default,
a \code{Key} object will be added to a whole \code{Music} object rather than to
any specific \code{Line} object.}

\item{scope}{Optional. \code{"part"} or \code{"staff"}, which indicates whether
to add the \code{Key} object to a whole part or only to a staff of a part,
if the argument \code{to} is specified, or this argument will be ignored.
The default value is \code{"part"}.}
}
\value{
A list with class \code{Key}.
}
\description{
Create a \code{Key} object.

\code{Key} objects represent key signatures.
}
\examples{
# create a Key object
Key(-7)

# insert a Key object into a specific measure
Music() + Key(7, bar = 2)

m <- Music() +
  Line(list("E5"), list(1), name = "a") +
  Line(list("C4"), list(1), name = "b", as = "staff")

# add a Key to a part
m + Key(2, to = "b")

# add a Key to a staff
m + Key(2, to = "b", scope = "staff")
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding \code{Key} objects to a \code{Music} object.
}
