% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{medianquotientnorm}
\alias{medianquotientnorm}
\title{Median Quotient Normalization of glycan data}
\usage{
medianquotientnorm(d, grouping = FALSE)
}
\arguments{
\item{d}{data frame in long format containing glycan measurements}

\item{grouping}{should data be normalized per groups}
}
\value{
Returns a data.frame with original glycan values substituted by normalized ones
}
\description{
Returns glycans normalized with Median Quotient Normalization approach.
}
\details{
Input data frame should have at least the following three columns: \cr
  - gid - representing a unique name of a sample \cr
  - glycan - representing glycan names \cr
  - value - representing measured values \cr
and if the grouping argument is \code{TRUE} it should also have column: \cr
  - groups - representing groupings (e.g. IgG1, IgG2 and IgG4)
}
\examples{
data(mpiu)
mpiun <- medianquotientnorm(mpiu)
head(mpiun)
}
\references{
Dieterle F,Ross A, Schlotterbeck G, Senn H.: \cr
Probabilistic Quotient Normalization as Robust Method to Account for
Diluition of Complex Biological Mixtures. Application in 1H NMR Metabolomics. \cr
Anal Chem 2006;78:4281-90. \cr
\doi{10.1021/ac051632c}
}
\author{
Ivo Ugrina, Lucija Klarić
}
