% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_3dglobdf}
\alias{search_3dglobdf}
\title{search_3dglobdf}
\usage{
search_3dglobdf(
  bbox,
  metadata,
  crop = TRUE,
  out_type = "poly",
  mask = FALSE,
  cell_size = 1
)
}
\arguments{
\item{bbox}{\code{sf}, \code{sfc}, or a numeric vector (xmin, ymin, xmax, ymax)
defining the area of interest.}

\item{metadata}{sf. Typically output from \code{\link[=get_metadata]{get_metadata()}}, containing tile
extents and download URLs.}

\item{crop}{logical. If \code{TRUE}, the resulting building footprint geometries
will be cropped to the input \code{bbox}. Default is \code{TRUE}.}

\item{out_type}{character. Default is \code{'poly'}.
Output type(s) to return. Options include:
\itemize{
\item \code{"poly"}: building footprints as an \code{sf} polygon object.
\item \code{"binary_rast"}: binary \code{terra} raster where buildings = 1.
\item \code{"graduated_rast"}: \code{terra} raster encoding building height values.
\item \code{"rast"}: a named list with both binary and graduated rasters.
\item \code{"all"}: a named list including the polygon layer and both raster layers.
}}

\item{mask}{logical (optional). Default is \code{FALSE}. If \code{TRUE}, masks the
graduated raster using the building footprint layer. Only used when \code{out_type}
is \code{"graduated_rast"}, \code{"rast"}, or \code{"all"}.}

\item{cell_size}{numeric (optional). Default is 1. Only used when \code{out_type}
is \code{"graduated_rast"}, \code{"rast"}, or \code{"all"}.}
}
\value{
Varies based on \code{out_type}:
\itemize{
\item If \code{"poly"}: an \code{sf} object of building footprints.
\item If \code{"binary_rast"}: a binary \code{SpatRaster} (\code{terra}) indicating building presence.
\item If \code{"graduated_rast"}: a quantitative \code{SpatRaster} of building heights.
\item If \code{"rast"}: a named list with two \code{SpatRaster} objects: \code{binary} and \code{graduated}.
\item If \code{"all"}: a named list with \code{poly} (sf), \code{binary}, and \code{graduated} rasters.
}
}
\description{
Search and retrieve 3D-GloBFP tiles that intersect a given bounding box or
area of interest, with options to return vector or raster outputs including
building polygons, binary presence rasters, and height-coded rasters.
}
\note{
The downloading process may take some time, depending on the number and size
of building footprint tiles.

This implementation relies on the current structure of the dataset as hosted on Figshare.
It may break if the dataset owner changes the file organization or metadata format.
}
\examples{
metadata <- gloBFPr::get_metadata(test=TRUE)
buildings <- gloBFPr::search_3dglobdf(bbox=c(-84.485519,45.636118,-84.462774,45.650639),
                     metadata=metadata)

}
\references{
Che Yangzi, Li Xuecao, Liu Xiaoping, Wang Yuhao, Liao Weilin, Zheng Xianwei,
Zhang Xucai, Xu Xiaocong, Shi Qian, Zhu Jiajun, Zhang Honghui, Yuan Hua, &
Dai Yongjiu (2024). 3D-GloBFP: the first global three-dimensional building
footprint dataset. Earth Syst. Sci. Data, 16, 5357-5374
}
