% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Trajan}
\alias{Trajan}
\title{Roots Produced by the Columnar Apple Cultivar Trajan.}
\format{
A data frame with 270 rows and 4 variables:
\describe{
  \item{roots}{a numeric vector indicating the number of roots produced.}
  \item{shoot}{a numeric vector indicating the number of micropropogated shoots.}
  \item{photoperiod}{a factor indicating the photoperiod, in hours: 8 or 16.}
  \item{bap}{a numeric vector indicating the concentrations of the cytokinin 6-benzylaminopurine: 2.2, 4.4, 8.8 or 17.6.}
}
}
\source{
\url{https://support.sas.com/rnd/app/stat/examples/GENMODZIP/sas.html}
}
\usage{
data(Trajan)
}
\description{
The data arose from a horticultural experiment to study
the number of roots produced by 270 micropropagated shoots of the
columnar apple cultivar Trajan. During the rooting period, all shoots
were maintained under identical conditions. However, the shoots
themselves were cultured on media containing different concentrations
of the cytokinin 6-benzylaminopurine (BAP), in growth cabinets with
an 8 or 16 hour photoperiod. The objective is to assess the effect
of both the photoperiod and BAP concentration levels on the number
of roots produced.
}
\examples{
data(Trajan)
dev.new()
boxplot(roots ~ bap, data=subset(Trajan,photoperiod=="8"), at=c(1:4) - 0.15,
        col="blue", boxwex=0.2, xaxt="n", ylim=c(-0.5,17))
boxplot(roots ~ bap, data=subset(Trajan,photoperiod=="16"), add=TRUE,
        at=c(1:4) + 0.15, col="yellow", boxwex=0.2, xaxt="n")
axis(1, at=c(1:4), labels=levels(Trajan$bap))
legend("topright", legend=c("8","16"), title="Photoperiod", bty="n",
       fill=c("blue","yellow"))

}
\references{
Ridout M., Demétrio C.G., Hinde J. (1998). Models for count data with many zeros. In
\emph{Proceedings of the XIXth international biometric conference}, 179–192.

Ridout M., Hinde J., Demétrio C.G. (2001). A score test for testing a zero-inflated
Poisson regression model against zero-inflated negative binomial alternatives. \emph{Biometrics}
57:219-223.

Garay A.M., Hashimoto E.M., Ortega E.M.M., Lachos V. (2011). On estimation and
influence diagnostics for zero-inflated negative binomial regression models. \emph{Computational
Statistics & Data Analysis} 55:1304-1318.
}
\keyword{datasets}
