% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{RJC}
\alias{RJC}
\title{Rotnitzky–Jewell's Criterion for Generalized Estimating Equations}
\usage{
RJC(..., verbose = TRUE, digits = 3)
}
\arguments{
\item{...}{one or several objects of the class \emph{glmgee}.}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}

\item{digits}{an (optional) integer indicating the number of digits to print.}
}
\value{
A \code{data.frame} with the values of the RJC for each \emph{glmgee} object in the input.
}
\description{
Computes the Rotnitzky–Jewell's criterion (RJC) for one or more objects of the class glmgee.
}
\examples{
###### Example 1: Effect of ozone-enriched atmosphere on growth of sitka spruces
data(spruces)
mod1 <- size ~ poly(days,4) + treat
fit1 <- glmgee(mod1, id=tree, family=Gamma(log), data=spruces)
fit2 <- update(fit1, corstr="AR-M-dependent")
fit3 <- update(fit1, corstr="Stationary-M-dependent(2)")
fit4 <- update(fit1, corstr="Exchangeable")
RJC(fit1, fit2, fit3, fit4)

###### Example 2: Treatment for severe postnatal depression
data(depression)
mod2 <- depressd ~ visit + group
fit1 <- glmgee(mod2, id=subj, family=binomial(logit), data=depression)
fit2 <- update(fit1, corstr="AR-M-dependent")
fit3 <- update(fit1, corstr="Stationary-M-dependent(2)")
fit4 <- update(fit1, corstr="Exchangeable")
RJC(fit1, fit2, fit3, fit4)

###### Example 3: Treatment for severe postnatal depression (2)
mod3 <- dep ~ visit*group
fit1 <- glmgee(mod3, id=subj, family=gaussian(identity), data=depression)
fit2 <- update(fit1, corstr="AR-M-dependent")
fit3 <- update(fit1, corstr="Exchangeable")
RJC(fit1, fit2, fit3)

}
\references{
Hin L.-Y., Carey V.J., Wang Y.-G. (2007) Criteria for Working–Correlation–Structure
Selection in GEE: Assessment via Simulation. \emph{The American Statistician} 61:360-364.
}
\seealso{
\link{QIC}, \link{CIC}, \link{GHYC}, \link{AGPC}, \link{SGPC}
}
