% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cellular}
\alias{cellular}
\title{Agents to stimulate cellular differentiation}
\format{
A data frame with 16 rows and 3 variables:
\describe{
  \item{cells}{a numeric vector giving the number of cells that exhibited markers of
differentiation after exposure to the dose of the two agents}
  \item{tnf}{a numeric vector giving the dose (U/ml) of TNF}
  \item{ifn}{a numeric vector giving the dose (U/ml) of IFN}
}
}
\usage{
data(cellular)
}
\description{
In a biomedical study of the immuno-activating ability of two agents, TNF (tumor necrosis factor)
and IFN (interferon), to induce cell differentiation, the number of cells that exhibited markers of
differentiation after exposure to TNF and IFN was recorded. At each of the 16 dose combinations of
TNF/INF, 200 cells were examined. The main question is whether the two
agents stimulate cell differentiation synergistically or independently.
}
\examples{
data(cellular)
barplot(100*cells/200 ~ ifn + tnf, beside=TRUE, data=cellular, col=terrain.colors(4),
        xlab="Dose of TNF", ylab="\% of cells with markers of differentiation")
legend(-3, 97, c("0","4","20","100"), fill=terrain.colors(4), bty="n", cex=0.9,
       title="Dose of IFN", x.intersp=0.2, y.intersp=1)
}
\references{
Piegorsch, W.W. and Weinberg, C.R. and Margolin, B.H. (1988) Exploring
simple independent action in multifactor tables of proportions. \emph{Biometrics} 44, 595-603.

Vanegas, L.H. and Rondon, L.M. (2020) A data transformation to deal with
constant under/over-dispersion in binomial and poisson regression models. \emph{Journal
of Statistical Computation and Simulation} 90, 1811-1833.
}
\keyword{datasets}
