% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm3.R
\name{estequa.overglm}
\alias{estequa.overglm}
\title{Estimating Equations for alternatives to the Poisson and Binomial Regression Models under the presence of Overdispersion.}
\usage{
\method{estequa}{overglm}(object, ...)
}
\arguments{
\item{object}{an object of the class \emph{overglm}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A vector with the values of the estimating equations evaluated at the parameter estimates and the observed data.
}
\description{
Computes the estimating equations evaluated at the parameter estimates and the observed data for
regression models based on the negative binomial, beta-binomial, and random-clumped binomial
distributions, which are alternatives to the Poisson and binomial regression models under the presence of overdispersion.
}
\examples{
### Example 1: Ability of retinyl acetate to prevent mammary cancer in rats
fit1 <- overglm(tumors ~ group, family="nb1(identity)", data=mammary)
estequa(fit1)

### Example 2: Self diagnozed ear infections in swimmers
fit2 <- overglm(infections ~ frequency + location, family="nb1(log)", data=swimmers)
estequa(fit2)

### Example 3: Urinary tract infections in HIV-infected men
fit3 <- overglm(episodes ~ cd4 + offset(log(time)), family="nb1(log)", data = uti)
estequa(fit3)

### Example 4: Article production by graduate students in biochemistry PhD programs
bioChemists <- pscl::bioChemists
fit4 <- overglm(art ~ fem + kid5 + ment, family="nb1(log)", data = bioChemists)
estequa(fit4)

### Example 5: Agents to stimulate cellular differentiation
fit5 <- overglm(cbind(cells,200-cells) ~ tnf + ifn, family="bb(logit)", data=cellular)
estequa(fit5)

### Example 6: Teratogenic effects of phenytoin and trichloropropene oxide
model6 <- cbind(fetuses,litter-fetuses) ~ pht + tcpo
fit6 <- overglm(model6, family="rcb(cloglog)", data=ossification)
estequa(fit6)

### Example 7: Germination of orobanche seeds
model7 <- cbind(germinated,seeds-germinated) ~ specie + extract
fit7 <- overglm(model7, family="rcb(cloglog)", data=orobanche)
estequa(fit7)

}
