% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glms.R
\name{gvif.glm}
\alias{gvif.glm}
\title{Generalized Variance Inflaction Factor}
\usage{
\method{gvif}{glm}(model, verbose = TRUE, ...)
}
\arguments{
\item{model}{an object of the class glm which is obtained from the fit of a generalized linear model.}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A matrix with so many rows as effects in the model and three columns: \emph{(1)} the values of GVIF; \emph{(2)} the number of degrees of freedom; and \emph{(3)} the values of GVIF^{1/(2*df)}.

If the number of degrees of freedom is 1 then the GVIF reduces to the Variance Inflation Factor (VIF).
}
\description{
Computes the generalized variance inflaction factor (GVIF) for a generalized linear model.
}
\examples{
## Example 1
Auto <- ISLR::Auto
fit1 <- glm(mpg ~ weight*horsepower, family=inverse.gaussian("log"), data=Auto)
gvif(fit1)

## Example 2
burn1000 <- aplore3::burn1000
mod <- death ~ age + tbsa + inh_inj + age*inh_inj + tbsa*inh_inj
fit2 <- glm(mod, family=binomial("logit"), data=burn1000)
gvif(fit2)

## Example 3
fit3 <- glm(rtime ~ log(distance) + log(cclimb), family=Gamma("log"), data=races)
gvif(fit3)

}
\references{
Fox J. and Monette G. (1992) Generalized collinearity diagnostics, \emph{JASA} 87, 178–183.
}
\seealso{
\link{gvif.lm}
}
