\name{glm.perm}
\alias{glm.perm}
\title{Deviance and Dispersion Factors for a Generalized Linear Model with Permuted Variables}
\description{
glm.perm permutes the residuals from a linear regression of the independent
variable of interest on the remaining independent variables, and then
computes the deviance and dispersion factor from a generalized linear model of these residuals and
the other independent variables on the dependent variable. (This
 function is intended to be used only by 'prr.test'.)
}
\usage{
glm.perm(y, x, Family)
}
\arguments{
  \item{y}{the dependent response variable; a vector.}
  \item{x}{a matrix of observations; the rows correspond to the sample size; the columns correspond the covariables. x must include a column of 1s for the intercept and a column called "resid" of the residuals from a linear regression of the 
variable of interest 'var' on the remaining independent variables. All other columns are identical to the remaining independent variables without 'var'. This matrix is automatically generated by 'prr.test'.
}
  \item{Family}{ Usually, this is the glm family used in 'prr.test' and is transferred to 'glm.perm' automatically.
}
}
\value{
'glm.perm' returns a matrix. The first column contains the deviance and the second column contains the dispersion factor as described above. The number of rows is the number of Monte Carlo replicates 'nrep' used in 'prr.test'. 
}
\references{
Potter D.M. (2005) \emph{A permutation test for inference in logistic regression with small- and moderate-sized datasets}. 
Statistics in Medicine, 24:693-708.
}
\author{
Douglas M. Potter (original version for logistic regression models), Wiebke Werft (extension for generalized linear models)
}
\examples{
nobs<-40
x1<-rnorm(nobs)
x2<-rnorm(nobs)
xx<-cbind(x1,x2)
xint<-rep(1,nobs)

x0<-rnorm(nobs)+x1+x2
y<-x0+x1+x2+2*rnorm(nobs)
y<-ifelse(y>0,1,0)
resid<-lm(x0~x1+x2)$residuals
x <- cbind(xint,xx,resid)
glm.perm(y,x, Family=binomial())
### with Family=binomial() the dispersion factor is always 1
glm.perm(y,x, Family=quasibinomial())
### with Family=quasibinomial() the dispersion factor is estimated from the data

### example for Family=poisson()
utils::data(treepipit, package="coin")
y <- treepipit$counts
nobs <- length(y)
xint<-rep(1,nobs)
resid <- lm(cbpiles~coverstorey ,data=treepipit)$residuals
x <- cbind(xint, treepipit$coverstorey, resid)
glm.perm(y,x, Family=poisson())
### with Family=poisson() the dispersion factor is always 1
glm.perm(y,x, Family=quasipoisson())
### with Family=quasipoisson() the dispersion factor is estimated from the data
}