% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mcml_full}
\alias{mcml_full}
\title{Markov Chain Monte Carlo Maximum Likelihood Algorithm}
\usage{
mcml_full(
  cov,
  data,
  eff_range,
  Z,
  X,
  y,
  family,
  link,
  start,
  mcnr = FALSE,
  m = 500L,
  maxiter = 30L,
  warmup = 500L,
  tol = 0.001,
  verbose = TRUE,
  lambda = 0.05,
  trace = 0L,
  refresh = 500L,
  maxsteps = 100L,
  target_accept = 0.9
)
}
\arguments{
\item{cov}{An integer matrix with columns of block identifier, dimension of block, function definition, number of variables
in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.}

\item{data}{Vector of data. Created by flattening the matrices in column-major order of the data used in each block.}

\item{eff_range}{Vector of values with the effective range parameters of the covariance functions, where required.}

\item{Z}{Matrix Z of the GLMM}

\item{X}{Matrix X of the GLMM}

\item{y}{Vector of observations}

\item{family}{Character specifying the family}

\item{link}{Character specifying the link function}

\item{start}{Vector of starting values for the optimisation}

\item{mcnr}{Logical indicating whether to use Newton-Raphson (TRUE) or Expectation Maximisation (FALSE)}

\item{m}{Integer. Total number of MCMC samples to draw on each iteration}

\item{maxiter}{Integer. The maximum number of MCML iterations}

\item{warmup}{Integer. The number of warmup iterations for the MCMC sampler. Note, this reduces to 10 after
the first iteration as the sampler starts from the last set of values and adaptive step size}

\item{tol}{Value of the tolerance. The algorithm termninates if differences in values of parameters between
iterations are all less than this value.}

\item{verbose}{Logical indicating whether to provide output to the console}

\item{lambda}{Value of the trajectory length of the leapfrog integrator in Hamiltonian Monte Carlo
(equal to number of steps times the step length). Larger values result in lower correlation in samples, but
require larger numbers of steps and so is slower.}

\item{trace}{Integer indicating what to report to the console, 0= nothing, 1-3=ever more detailed output}

\item{refresh}{Integer. Number of MCMC iterations to print progress to the console (requires verbose=TRUE)}

\item{maxsteps}{Integer. The maximum number of steps of the leapfrom integrator}

\item{target_accept}{The target acceptance rate of HMC proposals (default 0.9)}
}
\value{
A list with the maximum likelihood estimates of the model parameters, the final set of MCMC samples, and
and indciator for whether the algorithm converged.
}
\description{
Full Markov Chain Monte Carlo Maximum Likelihood Algorithm using c++ code and the inbuilt Hamiltonian Monte Carlo MCMC sampler.
Given their complex interface, these functions are not intended to be used by the normal user who can access this functionality 
with the member functions of the \link[glmmrMCML]{ModelMCML} class.
}
\examples{
\dontrun{
## small example with simulated data
## create data and model object with 
## parameters to simulate data and 
## act as starting values
df <- nelder(~(j(10) * t(3)) > i(5))
des <- ModelMCML$new(
 covariance = list(
  formula =  ~(1|gr(j)*ar1(t)),
  parameters = c(0.25,0.7)
),
mean = list(
  formula = ~factor(t)-1,
  parameters = rnorm(3)
),
data=df,
family=gaussian()
)
## simulate data
y <- des$sim_data()
## get covariance definition matrix
ddata <- des$covariance$get_D_data()
## fit model using default arguments for HMC sampler
out <- mcml_full(cov=ddata$cov,
   data=ddata$data,
   eff_range = rep(0,30),
   Z = as.matrix(des$covariance$Z),
   X = as.matrix(des$mean_function$X),
   y = y,
   family = des$mean_function$family[[1]],
   link=des$mean_function$family[[2]],
   start = c(rep(0.01,3),0.25,0.7,1.0),
   mcnr = TRUE)
}
}
