% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_options.R
\name{optimControl}
\alias{optimControl}
\title{Control of Penalized Generalized Linear Mixed Model Fitting}
\usage{
optimControl(
  conv_EM = 0.0015,
  conv_CD = 5e-04,
  nMC_burnin = NULL,
  nMC_start = NULL,
  nMC_max = NULL,
  nMC_report = 5000,
  maxitEM = NULL,
  maxit_CD = 50,
  M = 10000,
  t = 2,
  mcc = 2,
  sampler = c("stan", "random_walk", "independence"),
  var_start = "recommend"
)
}
\arguments{
\item{conv_EM}{a non-negative numeric convergence criteria for the convergence of the 
EM algorithm. Default is 0.0015. 
EM algorithm is considered to have converge if the average Euclidean 
distance between the current coefficient estimates and the coefficient estimates from 
\code{t} EM iterations back is less than \code{conv_EM} \code{mcc} times in a row.
See \code{t} and \code{mcc} for more details.}

\item{conv_CD}{a non-negative numeric convergence criteria for the convergence of the 
grouped coordinate descent loop within the M step of the EM algorithm. Default 0.0005.}

\item{nMC_burnin}{positive integer specifying the number of posterior samples to use as
burn-in for each E step in the EM algorithm. If set to \code{NULL}, the algorithm inputs
the following defaults: Default 250 when the number of random effects 
predictors is less than or equal to 10; default 100 otherwise. Function will not allow \code{nMC_burnin}
to be less than 100.}

\item{nMC_start}{a positive integer for the initial number of Monte Carlo draws. If set to
\code{NULL}, the algorithm inputs the following defaults: Default 250 when 
the number of random effects predictors is less than or equal to 10; default 100 otherwise.}

\item{nMC_max}{a positive integer for the maximum number of allowed Monte Carlo draws used
in each step of the EM algorithm. If set to \code{NULL}, the algorithm inputs the following 
defaults: When the number of random effect covariates is greater than 10,
the default is set to 1000; when the number of random effect covariates is
10 or less, the default is set to 2500.}

\item{nMC_report}{a positive integer for the number of posterior samples to save from the final
model. These posterior samples can be used for diagnostic purposes, see \code{\link{plot_mcmc}}.
Default set to 5000.}

\item{maxitEM}{a positive integer for the maximum number of allowed EM iterations. 
If set to \code{NULL}, then the algorithm inputs the following defaults:
Default equals 50 for the Binomial and Poisson families, 65 for the Gaussian family.}

\item{maxit_CD}{a positive integer for the maximum number of allowed iterations for the
coordinate descent algorithms used within the M-step of each EM iteration. Default equals 50.}

\item{M}{positive integer specifying the number of posterior samples to use within the 
Pajor log-likelihood calculation. Default is 10^4; minimum allowed value is 5000.}

\item{t}{the convergence criteria is based on the average Euclidean distance between 
the most recent coefficient estimates and the coefficient estimates from \code{t} EM iterations back.
Positive integer, default equals 2.}

\item{mcc}{the number of times the convergence criteria must be met before the algorithm is
seen as having converged (mcc for 'meet condition counter'). Default set to 2. Value restricted 
to be no less than 2.}

\item{sampler}{character string specifying whether the posterior samples of the random effects
should be drawn using Stan (default, from package rstan) or the Metropolis-within-Gibbs procedure 
incorporating an adaptive random walk sampler ("random_walk") or an
independence sampler ("independence"). If using the random walk sampler, see \code{\link{adaptControl}}
for some additional control structure parameters.}

\item{var_start}{either the character string "recommend" or a positive number specifying the 
starting values to initialize the variance of the covariance matrix. Default "recommend" first
fits a simple model with a fixed and random intercept only using the \link{lme4} package. The 
random intercept variance estimate from this model is then multiplied by 2 and used as the 
starting variance.}
}
\value{
Function returns a list inheriting from class \code{optimControl}
containing fit and optimization criteria values used in optimization routine.
}
\description{
Constructs the control structure for the optimization of the penalized mixed model fit algorithm.
}
\details{
Several arguments are set to a default value of \code{NULL}. If these arguments 
are left as \code{NULL} by the user, then these values will be filled in with appropriate
default values as specified above, which may depend on the number of random effects or
the family of the data. If the user
specifies particular values for these arguments, no additional modifications to these 
arguments will be done within the algorithm.
}
