% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{vcov_fixcoef}
\alias{vcov_fixcoef}
\alias{vcov_fixcoef.default}
\alias{vcov_fixcoef.survreg}
\title{Gets the variance-covariance matrix of fixed effects of a fitted model}
\usage{
vcov_fixcoef(model, ...)

\method{vcov_fixcoef}{default}(model, ...)

\method{vcov_fixcoef}{survreg}(model, ...)
}
\arguments{
\item{model}{a fitted statistical model}

\item{...}{argument unused by \code{\link{p_value_contrast.default}} but that may be useful to some specializations.}
}
\description{
This is a generic S3 function that gets the variance-covariance matrix of fixed effects of a statistical model, implemented on a wide range of models and that can be extended to new models.
}
\details{
It must return variance-covariance for fixed effects of a model, not random effects nor scale parameters.
The \code{rownames} and \code{colnames} of the returned matrix
must be consistent with \code{\link[base:names]{names}} of \code{\link{fixcoef}(object)}.

The functions \code{\link{vcov_fixcoef}} and \code{\link{fixcoef}} would be pointless if the behavior of
\code{\link[stats:vcov]{vcov}} and \code{\link[stats:coef]{coef}} were not inconsistent from package to package.

\code{fixcoef} and \code{vcov_fixcoef}, together with \code{\link{df_for_wald}} are used by \code{\link{p_value_contrast.default}}
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default implementation, simple proxy of \code{\link[stats:vcov]{vcov}(model)}

\item \code{survreg}: implementation for survreg, removing the extra column for Scale
}}

\examples{
data(mtcars)
mod = lm(data=mtcars, hp ~ cyl+wt)
est = fixcoef(mod) # get estimates
SE = sqrt(diag(vcov_fixcoef(mod))) # get standard errors of estimates
z  = est/SE # get z-score of estimates
df = df_for_wald(mod) # degrees of freedom
pvalues = 2*pt(-abs(z), df=df) # get two-sided P-values
}
\seealso{
Other Wald-related functions: 
\code{\link{df_for_wald}()},
\code{\link{fixcoef}()},
\code{\link{p_value_contrast}()}
}
\concept{Wald-related functions}
