% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordiplot.gllvm.R
\name{ordiplot.gllvm}
\alias{ordiplot.gllvm}
\alias{ordiplot}
\title{Plot latent variables from gllvm model}
\usage{
\method{ordiplot}{gllvm}(
  object,
  biplot = FALSE,
  ind.spp = NULL,
  alpha = 0.5,
  main = NULL,
  which.lvs = c(1, 2),
  predict.region = FALSE,
  level = 0.95,
  jitter = FALSE,
  jitter.amount = 0.2,
  s.colors = 1,
  s.cex = 1.2,
  symbols = FALSE,
  cex.spp = 0.7,
  spp.colors = "blue",
  arrow.scale = 0.8,
  arrow.spp.scale = 0.8,
  arrow.ci = TRUE,
  arrow.lty = "solid",
  spp.arrows = NULL,
  spp.arrows.lty = "dashed",
  cex.env = 0.7,
  lab.dist = 0.1,
  lwd.ellips = 0.5,
  col.ellips = 4,
  lty.ellips = 1,
  type = NULL,
  rotate = TRUE,
  ...
)
}
\arguments{
\item{object}{an object of class 'gllvm'.}

\item{biplot}{\code{TRUE} if both latent variables and their coefficients are plotted, \code{FALSE} if only latent variables.}

\item{ind.spp}{the number of response variables (usually, species) to include on the biplot. The default is none, or all if \code{biplot = TRUE}.}

\item{alpha}{a numeric scalar between 0 and 1 that is used to control the relative scaling of the latent variables and their coefficients, when constructing a biplot.}

\item{main}{main title.}

\item{which.lvs}{indices of two latent variables to be plotted if number of the latent variables is more than 2. A vector with length of two. Defaults to \code{c(1,2)}.}

\item{predict.region}{if \code{TRUE} or \code{"sites"} prediction regions for the predicted latent variables are plotted, defaults to \code{FALSE}. EXTENSION UNDER DEVELOPMENT: if \code{"species"} uncertainty estimate regions for the estimated latent variable loadings are plotted. Works only if \code{biplot = TRUE}.}

\item{level}{level for prediction regions.}

\item{jitter}{if \code{TRUE}, jittering is applied on points.}

\item{jitter.amount}{numeric, positive value indicating an amount of jittering for each point, defaults to 0.2 (jitter range).}

\item{s.colors}{colors for sites}

\item{s.cex}{size of site labels}

\item{symbols}{logical, if \code{TRUE} sites are plotted using symbols, if \code{FALSE} (default) site numbers are used}

\item{cex.spp}{size of species labels in biplot}

\item{spp.colors}{colors for sites, defaults to \code{"blue"}}

\item{arrow.scale}{positive value, to scale arrows}

\item{arrow.spp.scale}{positive value, to scale arrows of species}

\item{arrow.ci}{represent statistical uncertainty for arrows in constrained or concurrent ordination using confidence or prediction interval? Defaults to \code{TRUE}}

\item{arrow.lty}{linetype for arrows in constrained}

\item{spp.arrows}{plot species scores as arrows if outside of the range of the plot? Defaults to \code{FALSE} for linear response models and \code{TRUE} for quadratic response models.}

\item{spp.arrows.lty}{linetype for species arrows}

\item{cex.env}{size of labels for arrows in constrained ordination}

\item{lab.dist}{distance between label and arrow heads. Value between 0 and 1}

\item{lwd.ellips}{line width for prediction ellipses. See graphical parameter lwd.}

\item{col.ellips}{colors for prediction ellipses.}

\item{lty.ellips}{line type for prediction ellipses. See graphical parameter lty.}

\item{type}{which type of ordination plot to construct. Options are "residual", "conditional", and "marginal". Defaults to "residual" for GLLVMs with unconstrained latent variables and "conditional" otherwise.}

\item{rotate}{logical, if \code{TRUE} (default) latent variables are rotated to their principal direction using singular value decomposition}

\item{...}{additional graphical arguments.}
}
\description{
Plots latent variables and their corresponding coefficients (biplot).
}
\details{
Function constructs a scatter plot of two latent variables, i.e. an ordination plot. 
Latent variables are re-rotated to their principal direction using singular value decomposition,
so that the first plotted latent variable does not have to be the first latent variable in the model.
If only one latent variable is in the fitted model, latent variables are plotted against their corresponding row indices.
The latent variables are labeled using the row index of the response matrix y.

Coefficients related to latent variables are plotted in the same figure with the latent
variables if \code{biplot = TRUE}. They are labeled using the column names of y. The number
of latent variable coefficients to be plotted can be controlled by ind.spp. An argument alpha
is used to control the relative scaling of the latent variables and their coefficients.
If \code{alpha = 0.5}, the latent variables and their coefficients are on the same scale.
For details for constructing a biplot, see Gabriel (1971).

For a quadratic response model, species optima are plotted. Any species scores that are outside the range 
of the predicted site scores are not directly plotted, but their main direction is indicated with arrows instead.
This ensures that the plot remains on a reasonable scale.

Effects of environmental variables in constrained ordination are indicated with arrows.
If any of the arrows exceeds the range of the plot, arrows are scaled to 80% of the plot range,
but so that the relative contribution of predictors is maintained.
If standard errors are available in the provided model, the slopes of environmental variables
for which the 95% confidence intervals do not include zero are shown as red, while others 
are slightly less intensely coloured.

For constrained ordination, a conditional plot includes both fixed- and random-effects to 
optimally represent species co-occurrence patterns, corresponding to "conditional" site scores in \code{\link{getLV.gllvm}}.
Marginal corresponds to an ordination plot that excludes residual patterns (i.e. excluding the random-effect),
so that it is only available with num.lv.c>0 or num.RR>0. A conditional plot requires num.lv.c>0. 
The "residual" type corresponds to an ordination diagram of only residual patterns. 
See \link{getLV.gllvm} for details.
}
\note{
- If error is occurred when using \code{ordiplot()}, try full name of the function \code{ordiplot.gllvm()} as functions named 'ordiplot' might be found in other packages as well.
}
\examples{
#'# Extract subset of the microbial data to be used as an example
data(microbialdata)
y <- microbialdata$Y[, order(colMeans(microbialdata$Y > 0), 
                     decreasing = TRUE)[21:40]]
fit <- gllvm(y, family = poisson())
fit$logL
ordiplot(fit, predict.region = TRUE)
\dontrun{
#'## Load a dataset from the mvabund package
data(antTraits)
y <- as.matrix(antTraits$abund)
fit <- gllvm(y, family = poisson())
# Ordination plot:
ordiplot(fit)
# Biplot with 10 species
ordiplot(fit, biplot = TRUE, ind.spp = 10)
}
}
\references{
Gabriel, K. R. (1971). The biplot graphic display of matrices with application to principal component analysis. Biometrika, 58, 453-467.
}
\seealso{
\code{\link{getLV.gllvm}}.
}
\author{
Jenni Niku <jenni.m.e.niku@jyu.fi>, Francis K.C. Hui, Bert van der Veen
}
