% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stash.R
\name{stash_drop}
\alias{stash_drop}
\title{Drop stash}
\usage{
stash_drop(object = ".", index = 1)
}
\arguments{
\item{object}{path to a repository, or a \code{git_repository}
object, or the stash \code{object} to drop. Default is a
\code{path = '.'} to a reposiory.}

\item{index}{The index to the stash to drop. Only used when
\code{object} is a path to a repository or a
\code{git_repository} object. Default is \code{index = 1}.}
}
\value{
invisible NULL
}
\description{
Drop stash
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

# Configure a user
config(repo, user.name="Alice", user.email="alice@example.org")

# Create a file, add and commit
writeLines("Hello world!", file.path(path, "test.txt"))
add(repo, 'test.txt')
commit(repo, "Commit message")

# Change file
writeLines(c("Hello world!", "HELLO WORLD!"), file.path(path, "test.txt"))

# Create stash in repository
stash(repo)

# Change file
writeLines(c("Hello world!", "HeLlO wOrLd!"), file.path(path, "test.txt"))

# Create stash in repository
stash(repo)

# View stashes
stash_list(repo)

# Drop git_stash object in repository
stash_drop(stash_list(repo)[[1]])

## Drop stash using an index to stash
stash_drop(repo, 1)

# View stashes
stash_list(repo)
}
}
