% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabl.R
\name{tabl}
\alias{tabl}
\alias{tabl_data}
\title{Make a table from gist or commit class or a list of either}
\usage{
tabl(x, ...)

tabl_data(x)
}
\arguments{
\item{x}{Either a gist or commit class object or a list of either}

\item{...}{Ignored}
}
\value{
A data.frame or list of data.frame's
}
\description{
Make a table from gist or commit class or a list of either
}
\details{
For commits we return a single data.frame. For gists, we always 
return a list so that we are returning data consistently, 
regardless of variable return data. So you can always index to the main 
data.frame with gist metadata and file info by doing \code{result$data}, 
and likewise for  forks \code{result$forks} and history 
\code{result$history}
}
\examples{
\dontrun{
# from a gist object
x <- as.gist('f1403260eb92f5dfa7e1')
res <- tabl(x)
res$data
res$forks
res$history

# from a list
ss <- gists('minepublic')
tabl(ss[1:3])
lapply(tabl(ss[1:3]), "[[", "data")
# index to data slots, but also make single data.frame
tabl_data(tabl(ss[1:3]))
## manipulate with dplyr
library("dplyr")
tabl_data(tabl(ss[1:30])) \%>\% 
  select(id, description, owner_login) \%>\% 
  filter(grepl("gist gist gist", description))

# commits
x <- gists()[[2]] \%>\% commits()
tabl(x[[1]])

## many
x <- sapply(gists(per_page = 100), commits)
tabl(x) \%>\%
  select(id, login, change_status.total, url) \%>\% 
  filter(change_status.total > 50)
  
# pass in a url
gist("https://gist.github.com/expersso/4ac33b9c00751fddc7f8") \%>\% tabl
## many
gg <- gists()
(urls <- vapply(gg, "[[", "", "html_url"))
lapply(urls[1:5], as.gist) \%>\% tabl()

# gist with forks and history
gist('1642874') \%>\% tabl

# gist with history, no forks
gist('c96d2e453c95d0166408') \%>\% tabl 
}
}
