% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_healthcare.R
\name{gisco_get_healthcare}
\alias{gisco_get_healthcare}
\title{Get the healthcare services in Europe.}
\source{
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/reference-data/healthcare-services}
}
\usage{
gisco_get_healthcare(
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  country = NULL
)
}
\arguments{
\item{cache}{A logical whether to do caching. Default is \code{TRUE}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
\code{.geojson} file.}

\item{cache_dir}{A path to a cache directory. See Details on \code{\link{gisco_get}}.}

\item{verbose}{Display information. Useful for debugging,
default is \code{FALSE}.}

\item{country}{Optional. A character vector of country codes.
See Details on \code{\link{gisco_get}}.}
}
\value{
A \code{POINT} object.
}
\description{
The dataset contains information on main healthcare services considered to
be 'hospitals' by Member States.
}
\details{
Files are distributed on EPSG:4326. Metadata available on
\url{https://gisco-services.ec.europa.eu/pub/healthcare/metadata.pdf}.
}
\seealso{
\link{gisco_get}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
\concept{infrastructure}
