% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_countries.R
\name{gisco_get_countries}
\alias{gisco_get_countries}
\title{Download Geospatial Country Data from GISCO}
\source{
\href{https://gisco-services.ec.europa.eu/distribution/v2/countries/}{GISCO Countries}
}
\usage{
gisco_get_countries(
  resolution = "20",
  year = "2016",
  epsg = "4326",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  spatialtype = "RG",
  country = NULL,
  region = NULL
)
}
\arguments{
\item{resolution}{Resolution of the geospatial data. One of
\itemize{
   \item "60" (1:60million),
   \item "20" (1:20million)
   \item "10" (1:10million)
   \item "03" (1:3million) or
   \item "01" (1:1million).
   }}

\item{year}{Release year. One of
"2001", "2006", "2010", "2013", "2016" or "2020"}

\item{epsg}{projection of the map: 4-digit \href{https://spatialreference.org/ref/epsg/}{EPSG code}. One of:
\itemize{
\item "4326" - WGS84
\item "3035" - ETRS89 / ETRS-LAEA
\item "3857" - Pseudo-Mercator
}}

\item{cache}{a logical whether to do caching. Default is \code{TRUE}.}

\item{update_cache}{a logical whether to update cache.}

\item{cache_dir}{a path to a cache directory. The directory have to exist.  The \code{NULL} (default) uses and creates \code{/gisco} directory in the temporary directory from \code{\link{tempdir}}. The directory can also be set with \code{options(gisco_cache_dir = <path>)}.}

\item{spatialtype}{Type of geometry to be returned:
\itemize{
 \item RG: Regions - Multipolygon
 \item LB: Labels - Point
 \item BN: Boundaries - Multilines
 \item COASTL: coastlines - Multilines
 \item INLAND: inland boundaries - Multilines
}}

\item{country}{Optional. A character vector of countries. See Details}

\item{region}{Optional. A character vector of UN M49 region codes. Possible values are "Africa", "Americas", "Asia", "Europe", "Oceania". See Details and \link{gisco_countrycode}}
}
\value{
a \code{sf} object.
}
\description{
Downloads a simple feature (\code{sf}) object.
}
\details{
\code{country} and \code{region} only available when applicable.

\code{country} could be either a vector of country names, a vector of ISO3 country codes or
a vector of Eurostat country codes.
}
\note{
Please check the download and usage provisions on \link{gisco_attributions}.
}
\examples{

library(sf)

sf_world <- gisco_get_countries()
plot(st_geometry(sf_world), col = "seagreen2")
title(sub = gisco_attributions(), line = 1)


sf_africa <- gisco_get_countries(region = 'Africa')
plot(st_geometry(sf_africa),
     col = c("springgreen4", "darkgoldenrod1", "red2"))
title(sub = gisco_attributions(), line = 1)


sf_benelux <-
  gisco_get_countries(country = c('Belgium', 'Netherlands', 'Luxembourg'))
plot(st_geometry(sf_benelux),
     col = c("grey10", "orange", "deepskyblue2"))
title(sub = gisco_attributions(), line = 1)
}
\seealso{
\link{gisco_countrycode}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
