% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_attributions.R
\name{gisco_attributions}
\alias{gisco_attributions}
\title{Attribution when publishing GISCO data}
\usage{
gisco_attributions(lang = "en", copyright = FALSE)
}
\arguments{
\item{lang}{Language (two-letter \href{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes}{ISO_639-1} code). See details.}

\item{copyright}{Boolean. Whether to display the copyright notice or not on the console.}
}
\value{
A string with the attribution to be used.
}
\description{
Get the legal text to be used along with the data downloaded with this package
}
\details{
Current languages supported are "en" (English), "da" (Danish), "de" (German),
"es" (Spanish), "fi" (Finish), "fr" (French), "no" (Norwegian) and "sv" (Swedish).

Consider contributing if you spot any mistake or want to add a new language.
}
\note{
COPYRIGHT NOTICE

When data downloaded from \href{https://ec.europa.eu/eurostat/web/gisco/geodata/reference-data/administrative-units-statistical-units}{this page}
is used in any printed or electronic publication,
in addition to any other provisions
applicable to the whole Eurostat website,
data source will have to be acknowledged
in the legend of the map and
in the introductory page of the publication
with the following copyright notice:
\itemize{
	\item EN: (C) EuroGeographics for the administrative boundaries
	\item FR: (C) EuroGeographics pour les limites administratives
	\item DE: (C) EuroGeographics bezüglich der Verwaltungsgrenzen
}
For publications in languages other than
English, French or German,
the translation of the copyright notice
in the language of the publication shall be used.

If you intend to use the data commercially,
please contact EuroGeographics for
information regarding their licence agreements.
}
\examples{
en <- gisco_attributions()
gisco_attributions(lang = "es", copyright = TRUE )
gisco_attributions(lang = "XXX")
}
