% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_lau.R
\name{gisco_get_lau}
\alias{gisco_get_lau}
\title{Download Geospatial Local Administrative Units Data from GISCO}
\source{
\href{https://gisco-services.ec.europa.eu/distribution/v2/lau/}{GISCO Local Administrative Units}
}
\usage{
gisco_get_lau(
  year = "2016",
  epsg = "4326",
  update_cache = FALSE,
  cache_dir = NULL,
  country = NULL,
  gisco_id = NULL
)
}
\arguments{
\item{year}{Release year. One of
"2016", "2017", "2018" or "2019"}

\item{epsg}{projection of the map: 4-digit \href{https://spatialreference.org/ref/epsg/}{EPSG code}. One of:
\itemize{
\item "4326" - WGS84
\item "3035" - ETRS89 / ETRS-LAEA
\item "3857" - Pseudo-Mercator
}}

\item{update_cache}{a logical whether to update cache.}

\item{cache_dir}{a path to a cache directory. The directory have to exist.  The \code{NULL} (default) uses and creates \code{/gisco} directory in the temporary directory from \code{\link{tempdir}}. The directory can also be set with \code{options(gisco_cache_dir = <path>)}.}

\item{country}{Optional. A character vector of country codes. See details}

\item{gisco_id}{Optional. A character vector of GISCO_ID LAU values.}
}
\value{
a \code{POLYGON} object on \code{sf} format.
}
\description{
Downloads a simple feature (\code{sf}) object.
}
\details{
See \url{https://ec.europa.eu/eurostat/web/nuts/local-administrative-units} for more detail about LAUs.

If you experience any problem on download, try to download the file by any other method and set \code{cache_dir = <folder>}.

\code{country} could be either a vector of country names, a vector of ISO3 country codes or
a vector of Eurostat country codes.
}
\note{
Please check the download and usage provisions on \link{gisco_attributions}.
}
\examples{
library(sf)

lau <- gisco_get_lau(country = "Belgique")

plot(
  st_geometry(lau),
  col = c("black", "gold", "brown2"),
  border = "grey90"
)

title(
  main = "Local Administrative Units on Belgium (2016)",
  sub = gisco_attributions(copyright = FALSE),
  line = 1,
  cex.sub = 0.8
)
}
\seealso{
\link{gisco_get_communes}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
