% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gimme.R
\name{gimmeSEM}
\alias{gimme}
\alias{gimmeSEM}
\title{Group iterative multiple model estimation.}
\usage{
gimmeSEM(data     = "",
         out      = "",
         sep      = "",
         header   = ,
         ar       = FALSE,
         plot     = TRUE,
         subgroup = FALSE,
         paths    = NULL,
         deconvolve_hrf = FALSE,
         control  = NULL)
}
\arguments{
\item{data}{The path to the directory where the data files are located. Each file must contain one matrix for each
individual containing a T (time) by p (number of variables) matrix where the columns represent variables and
the rows represent time.}

\item{out}{The path to the directory where the results will be stored. This must be generated by the user prior
to running the function.}

\item{sep}{The spacing of the data files. "" indicates space-delimited, "/t" indicates tab-delimited, ","
indicates comma delimited.}

\item{header}{Logical. Indicate TRUE for data files with a header.}

\item{ar}{Logical. If TRUE, begins search for group model with autoregressive (AR) paths open. Defaults to FALSE.}

\item{plot}{Logical. If TRUE, graphs depicting relations among variables of interest will automatically be
created. For individual-level plots, red paths represent positive weights and blue paths represent negative weights. For the group-level plot, black represents group-level paths, grey represents individual-level paths, and (if subgroup = TRUE) green represents subgroup-level paths. For the group-level plot, the width of the edge corresponds to the count. Defaults to TRUE.}

\item{subgroup}{Logical. If TRUE, subgroups are generated based on similarities in model features using the \code{walktrap.community} function from the \code{igraph} package.}

\item{paths}{\code{lavaan}-style syntax containing paths with which to begin model estimation. That is, Y~X indicates that Y is regressed on X, or X predicts Y. If no header is used,
then variables should be referred to with V followed (with no separation) by the column number. If a
header is used, variables should be referred to using variable names. To reference lag variables, "lag"
should be added to the end of the variable name with no separation. Defaults to NULL.}

\item{deconvolve_hrf}{In development. Defaults to FALSE.}

\item{control}{In development. Defaults to NULL.}
}
\description{
This function identifies structural equation models for each individual that consist of both group-level and individual-level paths.
}
\details{
In main output directory:
 \itemize{
 \item{\strong{indivPathEstimates}} {Contains estimate, standard error, p-value, and z-value for each path for each individual}
 \item{\strong{summaryFit}} {Contains model fit information for individual-level models. If subgroups are requested, this file also contains the subgroup membership for each individual.}
 \item{\strong{summaryPathCountMatrix}} Contains counts of total number of paths, both contemporaneous and lagged, estimated for the sample. The row variable is the outcome and the column variable is the predictor variable.
 \item{\strong{summaryPathCounts}} {Contains summary count information for paths identified at the group-, subgroup (if subgroup = TRUE), and individual-level.}
 \item{\strong{summaryPathsPlot}} {Produced if plot = TRUE. Contains figure with group, subgroup (if subgroup = TRUE), and individual-level paths
 for the sample. Black paths are group-level, green paths are subgroup-level, and grey paths are individual-level, where the thickness of the line
 represents the count.}
 }
 In subgroup output directory (if subgroup = TRUE):
 \itemize{
 \item{\strong{subgroup\emph{k}PathCounts}} Contains counts of relations among lagged and contemporaneous variables for the \strong{\emph{k}}th subgroup.
 \item{\strong{subgroup\emph{k}Plot}} Contains plot of group, subgroup, and individual level paths for the \strong{\emph{k}}th subgroup. Black represents group-level paths, grey represents individual-level paths, and green represents subgroup-level paths.
 }
 Note: if a subgroup of size n = 1 is discovered, subgroup-level output is not produced. \cr
 In individual output directory (where \strong{\emph{id}} represents the original file name for each individual):
 \itemize{
 \item{\strong{\emph{id}Betas}} Contains individual-level estimates of each path for each individual.
 \item{\strong{\emph{id}StdErrors}} Contains individual-level standard errors for each path for each individual.
 \item{\strong{\emph{id}Plot}} Contains individual-level plots. Red paths represent positive weights and blue paths represent negative weights.
}
}
\examples{
\dontrun{
paths <- 'V2 ~ V1
          V3 ~ V4lag'

gimmeSEM(data     = "C:/data100",
         out      = "C:/data100_gimme_out",
         sep      = ",",
         header   = FALSE,
         ar       = TRUE,
         plot     = TRUE,
         paths    = paths,
         subgroup = FALSE)
 }
}
\author{
Stephanie Lane
}
\references{
Gates, K.M. & Molenaar, P.C.M. (2012). Group search algorithm recovers effective connectivity maps
for individuals in homogeneous and heterogeneous samples. NeuroImage, 63, 310-319.
}
\keyword{gimme}

