% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_giedata2.R
\name{get_giedata2}
\alias{get_giedata2}
\title{get_giedata2}
\usage{
get_giedata2(
  countries,
  companies = NULL,
  facilities = NULL,
  from = NULL,
  to = NULL,
  date = NULL,
  size = 30,
  timeout = 3,
  database = "agsi",
  verbose = FALSE,
  apikey = Sys.getenv("GIE_APIKEY")
)
}
\arguments{
\item{countries}{Character. Specify the countries of interest as two-digit \cr
country codes (e.g., 'DE', 'IE'). \cr
Must be of length one (i.e., one country) if you want to specify multiple \cr
companies and/or multiple facilities.}

\item{companies}{A character vector of company EIC codes to get data from. \cr
Must be of length one (i.e., one company) if you want to specify multiple \cr
facilities.}

\item{facilities}{A character vector of facility EIC codes to get data from.}

\item{from}{Character. Specify the start of the time span you are \cr
interested in downloading (format: YYYY-MM-DD).}

\item{to}{Character. Specify the end of the time span you are \cr
interested in downloading (format: YYYY-MM-DD).}

\item{date}{Character. If you want to have data only for one date. \cr
If you set 'date', you cannot set the 'from' and/or 'to' parameters \cr
(format: YYYY-MM-DD).}

\item{size}{Integer. The number of results per page.}

\item{timeout}{Numeric. If the amount of pages of your request exceeds 60, a timeout \cr
will be enforced to prevent the API from timing out. Defaults to 3 seconds, any \cr
values must be set in seconds, too.}

\item{database}{Character. The type of API you want to address ('agsi' or 'alsi').}

\item{verbose}{Logical. Prints information on function progress to the console (default: FALSE).}

\item{apikey}{Character. Your personal API key.}
}
\value{
A data.frame with results
}
\description{
Function to download data from GIE's AGSI+ API in bulk
}
\examples{
\dontrun{
get_giedata2(countries = c("DE", "AT", "FR"), date = "2022-04-01")
}

}
