% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_dict.R
\name{build_user_dic}
\alias{build_user_dic}
\title{Build user dictionary}
\usage{
build_user_dic(dic_dir, file, csv_file, encoding)
}
\arguments{
\item{dic_dir}{Directory where the source dictionaries are located.
This argument is passed as '-d' option argument.}

\item{file}{Path to write the user dictionary.
This argument is passed as '-u' option argument.}

\item{csv_file}{Path to an input csv file.}

\item{encoding}{Encoding of input csv files.
This argument is passed as '-f' option argument.}
}
\value{
A \code{TRUE} is invisibly returned if dictionary is successfully built.
}
\description{
Builds a UTF-8 user dictionary from a csv file.
}
\details{
This function is a wrapper around dictionary compiler of 'MeCab'.

Note that this function does not support auto assignment of word cost field.
So, you can't leave any word costs as empty in your input csv file.
To estimate word costs, use \code{posDebugRcpp()} function.
}
\examples{
\donttest{
if (requireNamespace("withr")) {
  # create a sample dictionary in temporary directory
  build_sys_dic(
    dic_dir = system.file("latin", package = "gibasa"),
    out_dir = tempdir(),
    encoding = "utf8"
  )
  # copy the 'dicrc' file
  file.copy(
    system.file("latin/dicrc", package = "gibasa"),
    tempdir()
  )
  # write a csv file and compile it into a user dictionary
  csv_file <- tempfile(fileext = ".csv")
  writeLines(
    c(
      "qa, 0, 0, 5, \u304f\u3041",
      "qi, 0, 0, 5, \u304f\u3043",
      "qu, 0, 0, 5, \u304f",
      "qe, 0, 0, 5, \u304f\u3047",
      "qo, 0, 0, 5, \u304f\u3049"
    ),
    csv_file
  )
  build_user_dic(
    dic_dir = tempdir(),
    file = (user_dic <- tempfile(fileext = ".dic")),
    csv_file = csv_file,
    encoding = "utf8"
  )
  # mocking a 'mecabrc' file to temporarily use the dictionary
  withr::with_envvar(
    c(
      "MECABRC" = if (.Platform$OS.type == "windows") {
        "nul"
      } else {
        "/dev/null"
      },
      "RCPP_PARALLEL_BACKEND" = "tinythread"
    ),
    {
      tokenize("quensan", sys_dic = tempdir(), user_dic = user_dic)
    }
  )
}
}
}
