% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtikzCanvas.R
\name{ggtikzCanvas}
\alias{ggtikzCanvas}
\title{Create a canvas to store TikZ annotations to a ggplot.}
\usage{
ggtikzCanvas(gg_plot)
}
\arguments{
\item{gg_plot}{A ggplot object on which annotations should be made.}
}
\value{
A ggtikzCanvas object, to which annotations can be added.
}
\description{
Annotations can be made relative to the whole plot, to a panel, or to data
coordinates (of individual panels).
}
\details{
This function provides a canvas for TikZ annotations, and does not draw
anything by itself. Its purpose is to provide information about the
underlying ggplot object for coordinate calculations.
}
\examples{
\dontrun{
library(ggplot2)
library(tikzDevice)
library(ggtikz)
p <- ggplot(mtcars, aes(disp, mpg)) + geom_point()

# Create a TikZ canvas on the plot
canvas <- ggtikzCanvas(p)

# Create annotations to add to the canvas

# Circle in the center of the plot
annotation1 <- ggtikzAnnotation(
   "\\\\fill[red] (0.5,0.5) circle (2mm);",
   xy = "plot")

# Arrow to data coordinate (400,20)
annotation2 <- ggtikzAnnotation(
   "\\\\draw[<-] (400,20) -- ++(0,2.5);",
   xy = "data", panelx = 1, panely = 1)

out <- tempfile(fileext = ".tikz")
tikz(out)
# First, draw the original plot
p
# Then, add the annotations to the canvas and draw it
canvas + annotation1 + annotation2
dev.off()
}

}
\seealso{
\code{\link[tikzDevice]{grid.tikzAnnotate}} for annotation of base
graphics.

\code{\link{ggtikz}} for a helper function for quick one-step
annotations.

\code{\link{ggtikzAnnotation}} for more information about creating
and adding ggtikz annotations.
}
