% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtibble.R
\name{ggtibble}
\alias{ggtibble}
\alias{ggtibble.data.frame}
\title{Make a tibble where one column is the data to plot, one is the gglist, and
one is the caption}
\usage{
ggtibble(data, ...)

\method{ggtibble}{data.frame}(
  data,
  mapping = ggplot2::aes(),
  ...,
  outercols = group_vars(data),
  labs = list(),
  caption = ""
)
}
\arguments{
\item{data}{The data.frame to plot}

\item{...}{Passed to subsequent methods (usually passed to \code{gglist()})}

\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot.}

\item{outercols}{The columns to have outside the nesting}

\item{labs}{Labels to add via \code{labs_glue()}}

\item{caption}{The glue specification for creating the caption}
}
\value{
A data.frame with a column named "data_plot" with the data to plot, "figure" with the gglist, and "caption" with the captions

A \code{ggtibble} object which is a tibble with columns named "figure"
which is a \code{gglist} object (a list of ggplots), "data_plot" which is the a
list of data.frames making up the source data used for each individual
plot, "caption" which is the text to use for the plot caption, and all of
the \code{outercols} used for nesting.
}
\description{
Make a tibble where one column is the data to plot, one is the gglist, and
one is the caption
}
\section{Methods (by class)}{
\itemize{
\item \code{ggtibble(data.frame)}: The default method for a data.frame or tibble

}}
\examples{
d_plot <-
  data.frame(
    A = rep(c("foo", "bar"), each = 4),
    B = 1:8,
    C = 11:18,
    Bunit = "mg",
    Cunit = "km"
  )
all_plots <-
  ggtibble(
    d_plot,
    ggplot2::aes(x = B, y = C),
    outercols = c("A", "Bunit", "Cunit"),
    caption = "All the {A}",
    labs = list(x = "B ({Bunit})", y = "C ({Cunit})")
  ) +
  ggplot2::geom_point() +
  ggplot2::geom_line()
knit_print(all_plots)
}
