% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel.R
\name{theme_excel}
\alias{theme_excel}
\title{ggplot theme based on old Excel plots}
\usage{
theme_excel(base_size = 12, base_family = "", horizontal = TRUE)
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}

\item{horizontal}{\code{logical}. Horizontal axis lines?}
}
\value{
An object of class \code{\link[ggplot2]{theme}()}.
}
\description{
Theme to replicate the ugly monstrosity that was the old
gray-background Excel chart. Please never use this.
This should be combined with
}
\examples{
library("ggplot2")

# Line and scatter plot colors
p <- ggplot(mtcars) +
     geom_point(aes(x = wt, y = mpg, colour = factor(gear))) +
     facet_wrap(~am)
p + theme_excel() + scale_colour_excel()

# Bar plot (area/fill) colors
ggplot(mpg, aes(x = class, fill = drv)) +
  geom_bar() +
  scale_fill_excel() +
  theme_excel()
}
\seealso{
Other themes excel: \code{\link{theme_excel_new}}
}
\concept{themes excel}
