% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-hex-tern.R, R/stat-hex-tern.R,
%   R/geom-tri-tern.R
\docType{data}
\name{geom_hex_tern}
\alias{geom_hex_tern}
\alias{GeomHexTern}
\alias{stat_hex_tern}
\alias{StatHexTern}
\alias{GeomTriTern}
\title{Hexbin (ggtern version).}
\usage{
geom_hex_tern(mapping = NULL, data = NULL, stat = "hex_tern",
  position = "identity", ..., fun = sum, na.rm = FALSE,
  show.legend = NA, inherit.aes = TRUE)

stat_hex_tern(mapping = NULL, data = NULL, geom = "hex_tern",
  position = "identity", ..., bins = 30, fun = sum, binwidth = NULL,
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{fun}{the scalar function to use for the statistic}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{geom, stat}{Override the default connection between `geom_hex_tern` and `stat_hex_tern`}

\item{bins}{numeric vector giving number of bins in both vertical and
horizontal directions. Set to 30 by default.}

\item{binwidth}{Numeric vector giving bin width in both vertical and
horizontal directions. Overrides \code{bins} if both set.}
}
\description{
Divides the plane into regular hexagons, counts the number of cases in
each hexagon, and then (by default) maps the number of cases to the hexagon
fill.  Hexagon bins avoid the visual artefacts sometimes generated by
the very regular alignment of [geom_bin2d()].
}
\details{
This geometry is loosely based on the base ggplot2 geom_hex, with a few subtle
(but advantageous differences). The user can control the border thickness of the
hexagonal polygons using the size aesthetic. The user can also control the
particular statistic to use, by defining the \code{fun} argument (sum by default), which by default
is applied over a value of 1 per point, however, this can also be mapped to a data variable
via the 'value' mapping.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggplot2:::rd_aesthetics("geom", "hex")}
}

\examples{
set.seed(1)
n  = 1000
df = data.frame(x  = runif(n),
                y  = runif(n),
                z  = runif(n),
                wt = runif(n))
                
#Equivalent of Hexbin
ggtern(df,aes(x,y,z)) + 
    geom_hex_tern(binwidth=0.1)
    
#Calculate Mean of variable wt
ggtern(df,aes(x,y,z)) + 
     geom_hex_tern(binwidth=0.05,
                   aes(value=wt),
                   fun=mean)

#Custom functions, for ex. discrete output...
myfun = function(x) sample(LETTERS,1)
ggtern(df,aes(x,y,z)) + 
     geom_hex_tern(binwidth=0.05,
                   fun=myfun)

}
\keyword{datasets}
