\name{stat_smooth}
\alias{stat_smooth}
\title{Add a smoother. (Ternary Version)}
\usage{
  stat_smooth(mapping = NULL, data = NULL,
    geom = "smoothtern", position = "identity",
    method = "auto", formula = y ~ x, se = TRUE, n = 80,
    fullrange = FALSE, level = 0.95, na.rm = FALSE, ...)
}
\arguments{
  \item{mapping}{The aesthetic mapping, usually constructed
  with \code{\link{aes}} or \code{\link{aes_string}}. Only
  needs to be set at the layer level if you are overriding
  the plot defaults.}

  \item{data}{A layer specific dataset - only needed if you
  want to override the plot defaults.}

  \item{geom}{The geometric object to use display the data}

  \item{position}{The position adjustment to use for
  overlappling points on this layer}

  \item{method}{smoothing method (function) to use, eg. lm,
  glm, gam, loess, rlm. For datasets with n < 1000 default
  is \code{\link{loess}}. For datasets with 1000 or more
  observations defaults to gam, see \code{\link[mgcv]{gam}}
  for more details.}

  \item{formula}{formula to use in smoothing function, eg.
  \code{y ~ x}, \code{y ~ poly(x, 2)}, \code{y ~ log(x)}}

  \item{se}{display confidence interval around smooth?
  (TRUE by default, see level to control}

  \item{n}{number of points to evaluate smoother at}

  \item{fullrange}{should the fit span the full range of
  the plot, or just the data}

  \item{level}{level of confidence interval to use (0.95 by
  default)}

  \item{na.rm}{If \code{FALSE} (the default), removes
  missing values with a warning.  If \code{TRUE} silently
  removes missing values.}

  \item{...}{other arguments are passed to smoothing
  function}
}
\description{
  Aids the eye in seeing patterns in the presence of
  overplotting
}
\seealso{
  \code{\link[ggplot2]{stat_smooth}}
}

