% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survfit2.R
\name{survfit2}
\alias{survfit2}
\title{Create survival curves}
\usage{
survfit2(formula, ...)
}
\arguments{
\item{formula}{
    a formula object, which must have a 
    \code{Surv} object as the  
    response on the left of the \code{~} operator and, if desired, terms  
    separated by + operators on the right. 
    One of the terms may be a \code{strata} object.
    For a single survival curve the right hand side should be \code{~ 1}.
  }

\item{...}{
  Arguments passed on to \code{\link[survival:survfit.formula]{survival::survfit.formula}}
  \describe{
    \item{\code{data}}{
    a data frame in which to interpret the variables named in the formula, 
    \code{subset} and \code{weights} arguments. 
  }
    \item{\code{weights}}{
    The weights must be nonnegative and it is strongly recommended that  
    they be strictly positive, since zero weights are ambiguous, compared 
    to use of the \code{subset} argument.
  }
    \item{\code{subset}}{
    expression saying that only a subset of the rows of the data 
    should be used in the fit. 
  }
    \item{\code{na.action}}{
    a missing-data filter function, applied to the model frame, after any 
    \code{subset} argument has been used. 
    Default is \code{options()$na.action}. 
  }
    \item{\code{stype}}{the method to be used estimation of the survival curve:
    1 = direct,  2 = exp(cumulative hazard). }
    \item{\code{ctype}}{the method to be used for estimation of the cumulative
    hazard: 1 = Nelson-Aalen formula, 2 = Fleming-Harrington correction
    for tied events.}
    \item{\code{id}}{
    identifies individual subjects, when a given person can have multiple
    lines of data.
  }
    \item{\code{cluster}}{used to group observations for the infinitesimal
    jackknife variance estimate, defaults to the value of id.}
    \item{\code{robust}}{logical, should the function compute a robust variance.
    For multi-state survival curves this is true by default.
    For single state data see details, below.}
    \item{\code{istate}}{for multi-state models, identifies the initial state of
    each subject or observation}
    \item{\code{timefix}}{process times through the \code{aeqSurv} function to
  eliminate potential roundoff issues.}
    \item{\code{etype}}{
    a variable giving the type of event.  This has been superseded by
    multi-state Surv objects and is deprecated; see example below.
  }
    \item{\code{error}}{this argument is no longer used}
  }}
}
\value{
survfit2 object
}
\description{
Simple wrapper for \code{survival::survfit.formula()} except the environment is also
included in the returned object.

Use this function with all other functions in this package to ensure
all elements are calculable.
}
\section{\code{survfit2()} vs \code{survfit()}}{


Both functions have identical inputs, so why do we need \code{survfit2()}?

The \emph{only} difference between \code{survfit2()} and \code{survival::survfit()} is that the
former tracks the environment from which the call to the function was made.

The definition of \code{survfit2()} is unremarkably simple:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{survfit2 <- function(formula, ...) \{
  # construct survfit object
  survfit <- survival::survfit(formula, ...)

  # add the environment
  survfit$.Environment = rlang::current_env()

  # add class and return
  class(survfit) <- c("survfit2", "survfit")
  survfit
\}
}\if{html}{\out{</div>}}

The environment is needed to ensure the survfit call can be accurately
reconstructed or parsed at any point post estimation.
The call is parsed when p-values are reported and when labels are created.
For example, the raw variable names appear in the output of a stratified
\code{survfit()} result, e.g. \code{"sex=Female"}. When using \code{survfit2()}, the
originating data frame and formula may be parsed and the raw variable
names removed.

Most functions in the package work with both \code{survfit2()} and \code{survfit()};
however, the output will be styled in a preferable format with \code{survfit2()}.
}

\examples{
# With `survfit()`
fit <- survfit(Surv(time, status) ~ sex, data = df_lung)
fit

# With `survfit2()`
fit2 <- survfit2(Surv(time, status) ~ sex, data = df_lung)
fit2

# Consistent behavior with other functions
summary(fit, times = c(10, 20))

summary(fit2, times = c(10, 20))

}
\seealso{
\code{\link[survival:survfit.formula]{survival::survfit.formula()}}
}
