% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_vline_year.R
\name{geom_vline_year}
\alias{geom_vline_year}
\alias{geom_hline_year}
\title{Automatically create lines at the turn of every year}
\usage{
geom_vline_year(
  mapping = NULL,
  position = "identity",
  year_break = "01-01",
  just = -0.5,
  ...,
  show.legend = NA
)

geom_hline_year(
  mapping = NULL,
  position = "identity",
  year_break = "01-01",
  just = -0.5,
  ...,
  show.legend = NA
)
}
\arguments{
\item{mapping}{Mapping created using \code{\link[ggplot2:aes]{ggplot2::aes()}}. Can be used to add the lines to the legend.
E.g. \code{aes(linetype = 'End of Year')}. Cannot access data specified in \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
Panels created by \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}} or \code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}} are available with \code{aes(linetype = PANEL)}.}

\item{position}{Position adjustment, either as a string, or the result of a call to
a position adjustment function.}

\item{year_break}{String specifying the month and day of the year break ("MM-DD").
Defaults to: \code{"01-01"} for January 1.}

\item{just}{Numeric offset in days (justification). Shifts the lines from the year break date.
Defaults to \code{-0.5}, which shifts the line by half a day so if falls in the middle between December 31 and January 1.}

\item{...}{Other arguments passed to \code{\link[ggplot2]{layer}}. For example:
\itemize{
\item \code{colour} Colour of the line. Try: \code{colour = "grey50"}
\item \code{linetype} Linetype. Try: \code{linetype = "dashed"} or \code{linetype = "dotted"}
\item \code{linewidth} Width of the line.
\item \code{alpha}  Transparency of the line.
used to set an aesthetic to a fixed value, like \code{colour = "grey25"} or \code{linetype = 2}.
}}

\item{show.legend}{logical. Should this layer be included in the legends? \code{NA}, the default,
includes if any aesthetics are mapped. \code{FALSE} never includes, and \code{TRUE} always includes.}
}
\value{
A ggplot2 layer that can be added to a plot.
}
\description{
Determines turn of year dates based on the range of either the x or y axis of the ggplot.
\itemize{
\item \code{geom_vline_year()} draws vertical lines at the turn of each year
\item \code{geom_hline_year()} draws horizontal lines at the turn of each year
}
}
\examples{
library(ggplot2)
set.seed(1)

plot_data_epicurve_imp <- data.frame(
  date = rep(as.Date("2023-12-01") + ((0:300) * 1), times = rpois(301, 0.5))
)

ggplot(plot_data_epicurve_imp, aes(x = date, weight = 2)) +
  geom_epicurve(date_resolution = "week") +
  geom_vline_year(year_break = "01-01", show.legend = TRUE) +
  labs(title = "Epicurve Example") +
  scale_y_cases_5er() +
  scale_x_date(date_breaks = "4 weeks", date_labels = "W\%V'\%g") + # Correct ISOWeek labels week'year
  theme_bw()

}
\seealso{
\code{\link[=geom_epicurve]{geom_epicurve()}}, \code{\link[ggplot2:geom_abline]{ggplot2::geom_vline()}}
}
