% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_gghistostats_graphics.R
\name{histo_labeller}
\alias{histo_labeller}
\title{Custom function for adding labeled lines for \code{x}-axis variable.}
\usage{
histo_labeller(
  plot,
  x,
  y.label.position,
  test.value = 0,
  test.k = 0,
  test.value.line = FALSE,
  test.value.line.args = list(size = 1),
  test.value.label.args = list(),
  centrality.parameter = "mean",
  centrality.k = 2,
  centrality.line.args = list(color = "blue", size = 1),
  centrality.label.args = list(color = "blue"),
  ...
)
}
\arguments{
\item{plot}{A \code{ggplot} object for which the labeled lines need to be added
for a test value and/or a centrality parameter (mean/median) value.}

\item{x}{A numeric variable.}

\item{test.value}{A number specifying the value of the null hypothesis
(Default: \code{0}).}

\item{test.k}{Integer denoting the number of decimal places expected for
\code{test.value} label. (Default: \code{0} ).}

\item{test.value.line}{Logical that decides whether a line corresponding to
the \code{test.value} should be superimposed on the plot.}

\item{test.value.line.args}{A list of additional aesthetic arguments to be
passed to the \code{geom_line} used to display the line corresponding to
\code{test.value}.}

\item{centrality.parameter}{Decides \emph{which} measure of central tendency
(\code{"mean"} or \code{"median"}) is to be displayed as a vertical line. To not show
any parameter, set this to \code{"none"}.}

\item{centrality.k}{Integer denoting the number of decimal places expected
for centrality parameter label. (Default: \code{2}).}

\item{centrality.line.args, test.value.line.args}{A list of additional
aesthetic arguments to be passed to the \code{geom_line} used to display the
lines corresponding to the centrality parameter and test value.}

\item{centrality.label.args, test.value.label.args}{A list of additional
aesthetic arguments to be passed to the \code{geom_label} used to display the
label corresponding to the centrality parameter and test value.}

\item{...}{Currently ignored.}
}
\description{
Helper function for adding centrality parameter value and/or a
test value for the continuous, numeric \code{x}-axis variable.
}
\examples{
\donttest{
library(ggplot2)

# creating a plot; lines and labels will be superposed on this plot
p <- ggplot(mtcars, aes(wt, mpg)) +
  geom_point()

# computing `y`-axis positions for line labels
y_label_pos <- median(
  x = ggplot2::layer_scales(p)$y$range$range,
  na.rm = TRUE
)
# adding labels
ggstatsplot:::histo_labeller(
  plot = p,
  x = mtcars$wt,
  y.label.position = y_label_pos,
  test.value.line = TRUE
)
}
}
\keyword{internal}
