% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggscatterstats.R
\name{grouped_ggscatterstats}
\alias{grouped_ggscatterstats}
\title{Scatterplot with marginal distributions for all levels of a grouping
variable}
\usage{
grouped_ggscatterstats(
  data,
  ...,
  grouping.var,
  plotgrid.args = list(),
  annotation.args = list()
)
}
\arguments{
\item{data}{A data frame (or a tibble) from which variables specified are to
be taken. Other data types (e.g., matrix,table, array, etc.) will \strong{not}
be accepted. Additionally, grouped data frames from \code{{dplyr}} should be
ungrouped before they are entered as \code{data}.}

\item{...}{
  Arguments passed on to \code{\link[=ggscatterstats]{ggscatterstats}}
  \describe{
    \item{\code{label.var}}{Variable to use for points labels entered as a symbol (e.g.
\code{var1}).}
    \item{\code{label.expression}}{An expression evaluating to a logical vector that
determines the subset of data points to label (e.g. \code{y < 4 & z < 20}).
While using this argument with \code{purrr::pmap()}, you will have to provide a
quoted expression  (e.g. \code{quote(y < 4 & z < 20)}).}
    \item{\code{point.label.args}}{A list of additional aesthetic arguments to be passed
to \code{ggrepel::geom_label_repel} geom used to display the labels.}
    \item{\code{smooth.line.args}}{A list of additional aesthetic arguments to be passed
to \code{geom_smooth} geom used to display the regression line.}
    \item{\code{point.args}}{A list of additional aesthetic arguments to be passed
to \code{geom_point} geom used to display the raw data points.}
    \item{\code{marginal}}{Decides whether marginal distributions will be plotted on
axes using \code{ggside} functions. The default is \code{TRUE}. The package
\code{ggside} must already be installed by the user.}
    \item{\code{point.width.jitter,point.height.jitter}}{Degree of jitter in \code{x} and \code{y}
direction, respectively. Defaults to \code{0} (0\%) of the resolution of the
data. Note that the jitter should not be specified in the \code{point.args}
because this information will be passed to two different \code{geom}s: one
displaying the \strong{points} and the other displaying the *\strong{labels} for
these points.}
    \item{\code{xsidehistogram.args,ysidehistogram.args}}{A list of arguments passed to
respective \code{geom_}s from the \code{{ggside}} package to change the marginal
distribution histograms plots.}
    \item{\code{x}}{The column in \code{data} containing the explanatory variable to be
plotted on the \code{x}-axis.}
    \item{\code{y}}{The column in \code{data} containing the response (outcome) variable to
be plotted on the \code{y}-axis.}
    \item{\code{type}}{A character specifying the type of statistical approach:
\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

You can specify just the initial letter.}
    \item{\code{k}}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}
    \item{\code{conf.level}}{Scalar between \code{0} and \code{1} (default: \verb{95\%}
confidence/credible intervals, \code{0.95}). If \code{NULL}, no confidence intervals
will be computed.}
    \item{\code{tr}}{Trim level for the mean when carrying out \code{robust} tests. In case
of an error, try reducing the value of \code{tr}, which is by default set to
\code{0.2}. Lowering the value might help.}
    \item{\code{bf.prior}}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors and posterior estimates. In
addition to numeric arguments, several named values are also recognized:
\code{"medium"}, \code{"wide"}, and \code{"ultrawide"}, corresponding to \emph{r} scale values
of 1/2, sqrt(2)/2, and 1, respectively. In case of an ANOVA, this value
corresponds to scale for fixed effects.}
    \item{\code{xlab}}{Label for \code{x} axis variable. If \code{NULL} (default),
variable name for \code{x} will be used.}
    \item{\code{ylab}}{Labels for \code{y} axis variable. If \code{NULL} (default),
variable name for \code{y} will be used.}
    \item{\code{bf.message}}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}
    \item{\code{results.subtitle}}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}
    \item{\code{subtitle}}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}
    \item{\code{caption}}{The text for the plot caption. This argument is relevant only
if \code{bf.message = FALSE}.}
    \item{\code{ggplot.component}}{A \code{ggplot} component to be added to the plot prepared
by \code{{ggstatsplot}}. This argument is primarily helpful for \code{grouped_}
variants of all primary functions. Default is \code{NULL}. The argument should
be entered as a \code{{ggplot2}} function or a list of \code{{ggplot2}} functions.}
    \item{\code{ggtheme}}{A \code{{ggplot2}} theme. Default value is
\code{ggstatsplot::theme_ggstatsplot()}. Any of the \code{{ggplot2}} themes (e.g.,
\code{theme_bw()}), or themes from extension packages are allowed (e.g.,
\code{ggthemes::theme_fivethirtyeight()}, \code{hrbrthemes::theme_ipsum_ps()}, etc.).
But note that sometimes these themes will remove some of the details that
\code{{ggstatsplot}} plots typically contains. For example, if relevant,
\code{ggbetweenstats()} shows details about multiple comparison test as a label
on the secondary Y-axis. Some themes (e.g.
\code{ggthemes::theme_fivethirtyeight()}) will remove the secondary Y-axis and
thus the details as well.}
  }}

\item{grouping.var}{A single grouping variable.}

\item{plotgrid.args}{A \code{list} of additional arguments passed to
\code{patchwork::wrap_plots()}, except for \code{guides} argument which is already
separately specified here.}

\item{annotation.args}{A \code{list} of additional arguments passed to
\code{patchwork::plot_annotation()}.}
}
\description{
Grouped scatterplots from \code{{ggplot2}} combined with marginal distribution
plots with statistical details added as a subtitle.
}
\details{
For details, see:
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggscatterstats.html}
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") && requireNamespace("ggside", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# to ensure reproducibility
set.seed(123)

library(dplyr, warn.conflicts = FALSE)
library(ggplot2)

# basic function call
grouped_ggscatterstats(
  data             = filter(movies_long, genre == "Comedy" | genre == "Drama"),
  x                = length,
  y                = rating,
  type             = "robust",
  grouping.var     = genre,
  ggplot.component = list(geom_rug(sides = "b"))
)

# using labeling
# (also show how to modify basic plot from within function call)
grouped_ggscatterstats(
  data             = filter(ggplot2::mpg, cyl != 5),
  x                = displ,
  y                = hwy,
  grouping.var     = cyl,
  type             = "robust",
  label.var        = manufacturer,
  label.expression = hwy > 25 & displ > 2.5,
  ggplot.component = scale_y_continuous(sec.axis = dup_axis())
)

# labeling without expression
grouped_ggscatterstats(
  data            = filter(movies_long, rating == 7, genre \%in\% c("Drama", "Comedy")),
  x               = budget,
  y               = length,
  grouping.var    = genre,
  bf.message      = FALSE,
  label.var       = "title",
  annotation.args = list(tag_levels = "a")
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{ggscatterstats}}, \code{\link{ggcorrmat}},
\code{\link{grouped_ggcorrmat}}
}
