% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_messages.R
\name{bartlett_message}
\alias{bartlett_message}
\title{Display homogeneity of variance test as a message}
\usage{
bartlett_message(data, x, y, lab = NULL, k = 2, output = "message")
}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken.}

\item{x}{The grouping variable.}

\item{y}{The response - a vector of length the number of rows of \code{x}.}

\item{lab}{A character describing label for the variable. If \code{NULL}, variable
name will be used.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{output}{What output is desired: \code{"message"} (default) or \code{"stats"}
objects.}
}
\value{
A list of class \code{"htest"} containing the following components:
  \item{statistic}{Bartlett's K-squared test statistic.}
  \item{parameter}{the degrees of freedom of the approximate chi-squared
    distribution of the test statistic.}
  \item{p.value}{the p-value of the test.}
  \item{method}{the character string
    \code{"Bartlett test of homogeneity of variances"}.}
  \item{data.name}{a character string giving the names of the data.}
}
\description{
A note to the user about the validity of assumptions for the
default linear model.
}
\examples{

# getting message
bartlett_message(
  data = iris,
  x = Species,
  y = Sepal.Length,
  lab = "Iris Species"
)

# getting results from the test
bartlett_message(
  data = mtcars,
  x = am,
  y = wt,
  output = "stats"
)
}
\seealso{
\code{\link{ggbetweenstats}}

Other helper_messages: \code{\link{effsize_ci_message}},
  \code{\link{ggcorrmat_matrix_message}},
  \code{\link{grouped_message}},
  \code{\link{normality_message}},
  \code{\link{pairwise_p}}, \code{\link{palette_message}}
}
\author{
Indrajeet Patil
}
\concept{helper_messages}
