% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdotplotstats.R
\name{ggdotplotstats}
\alias{ggdotplotstats}
\alias{ggdotchartstats}
\title{Dot plot/chart for labeled numeric data.}
\usage{
ggdotplotstats(data, x, y, xlab = NULL, ylab = NULL, title = NULL,
  stat.title = NULL, subtitle = NULL, caption = NULL,
  type = "parametric", test.value = 0, bf.prior = 0.707,
  bf.message = TRUE, robust.estimator = "onestep",
  effsize.type = "g", effsize.noncentral = TRUE, conf.level = 0.95,
  nboot = 100, k = 2, results.subtitle = TRUE,
  ggtheme = ggplot2::theme_bw(), ggstatsplot.layer = TRUE,
  point.color = "black", point.size = 3, point.shape = 16,
  centrality.para = "mean", centrality.color = "blue",
  centrality.size = 1, centrality.linetype = "dashed",
  centrality.line.labeller = TRUE, centrality.k = 2,
  test.value.line = FALSE, test.value.color = "black",
  test.value.size = 1, test.value.linetype = "dashed",
  test.line.labeller = TRUE, test.k = 0, ggplot.component = NULL,
  return = "plot", messages = TRUE)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{A numeric variable.}

\item{y}{Label or grouping variable.}

\item{xlab}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}

\item{ylab}{Label for \code{y} axis variable.}

\item{title}{The text for the plot title.}

\item{stat.title}{A character describing the test being run, which will be
added as a prefix in the subtitle. The default is \code{NULL}. An example of a
\code{stat.title} argument will be something like \code{"Student's t-test: "}.}

\item{subtitle}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}

\item{caption}{The text for the plot caption.}

\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}

\item{test.value}{A number specifying the value of the null hypothesis
(Default: \code{0}).}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}

\item{bf.message}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}

\item{robust.estimator}{If \code{test = "robust"} robust estimator to be used
(\code{"onestep"} (Default), \code{"mom"}, or \code{"median"}). For more, see
\code{?WRS2::onesampb}.}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"biased"} (\code{"d"} for Cohen's \emph{d}) or \code{"unbiased"}
(\code{"g"} Hedge's \emph{g} for \strong{t-test}). The default is}

\item{effsize.noncentral}{Logical indicating whether to use non-central
\emph{t}-distributions for computing the confidence interval for Cohen's \emph{d}
or Hedge's \emph{g} (Default: \code{TRUE}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\code{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{results.subtitle}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}

\item{ggtheme}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_fivethirtyeight()},
\code{hrbrthemes::theme_ipsum_ps()}, etc.).}

\item{ggstatsplot.layer}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}).}

\item{point.color}{Character describing color for the point (Default:
\code{"black"}).}

\item{point.size}{Numeric specifying size for the point (Default: \code{3}).}

\item{point.shape}{Numeric specifying shape to draw the points (Default: \code{16}
(\strong{a dot})).}

\item{centrality.para}{Decides \emph{which} measure of central tendency (\code{"mean"}
or \code{"median"}) is to be displayed as a vertical line.}

\item{centrality.color}{Decides color for the vertical line for centrality
parameter (Default: \code{"blue"}).}

\item{centrality.size}{Decides size for the vertical line for centrality
parameter (Default: \code{1.2}).}

\item{centrality.linetype}{Decides linetype for the vertical line for
centrality parameter (Default: \code{"dashed"}).}

\item{centrality.line.labeller}{A logical that decides whether line labels
should be displayed for the \strong{centrality.para} line (Default: \code{TRUE}).}

\item{centrality.k}{Integer denoting the number of decimal places expected
for centrality parameter label. (Default: \code{2}).}

\item{test.value.line}{Decides whether test value is to be displayed as a
vertical line (Default: \code{FALSE}).}

\item{test.value.color}{Decides color for the vertical line denoting test
value (Default: \code{"black"}).}

\item{test.value.size}{Decides size for the vertical line for test value
(Default: \code{1.2}).}

\item{test.value.linetype}{Decides linetype for the vertical line for test
value (Default: \code{"dashed"}).}

\item{test.line.labeller}{A logical that decides whether line labels should
be displayed for \strong{test.value} line (Default: \code{TRUE}).}

\item{test.k}{Integer denoting the number of decimal places expected for
\code{test.value} label. (Default: \code{0} ).}

\item{ggplot.component}{A \code{ggplot} component to be added to the plot prepared
by \code{ggstatsplot}. This argument is primarily helpful for \code{grouped_} variant
of the current function. Default is \code{NULL}. The argument should be entered
as a function. If the given function has an argument \code{axes.range.restrict}
and if it has been set to \code{TRUE}, the added ggplot component \emph{might} not
work as expected.}

\item{return}{Character that describes what is to be returned: can be
\code{"plot"} (default) or \code{"subtitle"} or \code{"caption"}. Setting this to
\code{"subtitle"} will return the expression containing statistical results,
which will be a \code{NULL} if you set \code{results.subtitle = FALSE}. Setting this
to \code{"caption"} will return the expression containing details about Bayes
Factor analysis, but valid only when \code{type = "p"} and \code{bf.message = TRUE},
otherwise this will return a \code{NULL}.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
}
\description{
A dot chart with statistical details from one-sample test
included in the plot as a subtitle.
}
\examples{
# for reproducibility
set.seed(123)

# plot
ggdotplotstats(
  data = ggplot2::mpg,
  x = cty,
  y = manufacturer,
  conf.level = 0.99,
  test.value = 15,
  test.value.line = TRUE,
  test.line.labeller = TRUE,
  test.value.color = "red",
  centrality.para = "median",
  centrality.k = 0,
  title = "Fuel economy data",
  xlab = "city miles per gallon",
  caption = substitute(
    paste(italic("Source"), ": EPA dataset on http://fueleconomy.gov")
  )
)
}
\seealso{
\code{\link{grouped_gghistostats}}, \code{\link{gghistostats}},
\code{\link{grouped_ggdotplotstats}}
}
\author{
Indrajeet Patil
}
