% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggcoefstats.R
\name{bf_meta_message}
\alias{bf_meta_message}
\title{Bayes factor message for random-effects meta-analysis}
\usage{
bf_meta_message(data, k = 2, d = "norm", d.par = c(0, 0.3),
  tau = "halfcauchy", tau.par = 0.5, sample = 10000,
  summarize = "integrate", caption = NULL, messages = TRUE, ...)
}
\arguments{
\item{data}{A dataframe. It \strong{must} contain columns named \code{estimate}
(corresponding estimates of coefficients or other quantities of interest)
and \code{std.error} (the standard error of the regression term).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{d}{type of prior for mean effect \eqn{d} (see \code{\link{prior}})}

\item{d.par}{prior parameters for \eqn{d}}

\item{tau}{type of prior for standard deviation of study effects \eqn{\tau} in random-effects meta-analysis (i.e., the SD of d across studies; see \code{\link{prior}})}

\item{tau.par}{prior parameters for \eqn{\tau}}

\item{sample}{number of samples in JAGS after burn-in and thinning (see \code{\link[runjags]{run.jags}}). Samples are used to get posterior  estimates for each study effect (which will show shrinkage). Only works for priors defined in \code{\link{prior}}.}

\item{summarize}{whether and to compute parameter summaries (mean, median, SD, 95\% quantile interval, HPD interval). If \code{summarize = "integrate"}, numerical integration is used  (which is precise but can require some seconds of computing time), \code{summarize = "jags"} summarizes the JAGS samples, and \code{summarize = "none"} suppresses parameter summaries.}

\item{caption}{The text for the plot caption.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{arguments passed to \link[runjags]{run.jags} (e.g., MCMC parameters such as \code{sample}, \code{burnin}, \code{n.chains}, \code{thin} or \code{method="parallel"})}
}
\description{
Bayes factor message for random-effects meta-analysis
}
\examples{

\donttest{
# setup
set.seed(123)
library(metaBMA)

# creating a dataframe
(df <-
  structure(
    .Data = list(
      study = c("1", "2", "3", "4", "5"),
      estimate = c(
        0.382047603321706,
        0.780783111514665,
        0.425607573765058,
        0.558365541235078,
        0.956473848429961
      ),
      std.error = c(
        0.0465576338644502,
        0.0330218199731529,
        0.0362834986178494,
        0.0480571500648261,
        0.062215818388157
      )
    ),
    row.names = c(NA, -5L),
    class = c("tbl_df", "tbl", "data.frame")
  ))

# getting bayes factor in favor of null hypothesis
ggstatsplot::bf_meta_message(
  data = df,
  k = 3,
  sample = 50,
  messages = FALSE
)
}

}
