% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gghistostats.R
\name{gghistostats}
\alias{gghistostats}
\title{histogram for distribution of a numeric variable}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken.}

\item{x}{A numeric variable.}

\item{xlab}{Label for \code{x} axis variable.}

\item{title}{The text for the plot title.}

\item{subtitle}{The text for the plot subtitle \emph{if} you don't want results
from one sample test to be displayed.}

\item{caption}{The text for the plot caption.}

\item{type}{Type of statistic expected ("parametric" or "nonparametric").
Abbreviations accepted are "p" or "np".}

\item{test.value}{A number specifying the value of the null hypothesis.}

\item{k}{Number of decimal places expected for results.}

\item{results.subtitle}{Decides whether the results of statistical tests are
to be displayed as subtitle.}

\item{density.plot}{Decides whether kernel density estimate, which is a
smoothed version of the histogram, is to be overlayed on top of the
histogram.}

\item{density.colour}{Decides colour for the density plot.}

\item{centrality.para}{Decides \emph{which} measure of central tendency ("mean" or
"median") is to be displayed as a vertical line.}

\item{centrality.colour}{Decides colour for the vertical line.}

\item{binwidth.adjust}{If set to \code{TRUE}, you can use it to pick better value
with the \code{binwidth} argument to \code{stat_bin()}.}

\item{binwidth}{The width of the bins. Can be specified as a numeric value,
or a function that calculates width from \code{x}. The default is to use bins
bins that cover the range of the data. You should always override this
value, exploring multiple widths to find the best to illustrate the stories
in your data.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
}
\description{
Histogram with statistical details from one-sample test included
in the plot as a subtitle.
}
\examples{

library(datasets)
library(ggplot2)

# most basic function call with the defaults
ggstatsplot::gghistostats(
data = ggplot2::diamonds,
x = carat)

# more detailed function call
ggstatsplot::gghistostats(
data = datasets::iris,
x = Sepal.Length,
type = "parametric",
test.value = 3,
centrality.para = "mean",
density.plot = TRUE,
binwidth.adjust = TRUE,
binwidth = 0.10
)

}
\author{
Indrajeet Patil
}
