% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-wlength.R
\name{w_length_label}
\alias{w_length_label}
\alias{w_number_label}
\alias{w_frequency_label}
\title{Wave- axis labels}
\usage{
w_length_label(unit.exponent = -9,
  format = getOption("photobiology.math", default = "R.expression"))

w_number_label(unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"))

w_frequency_label(unit.exponent = 9,
  format = getOption("photobiology.math", default = "R.expression"))
}
\arguments{
\item{unit.exponent}{integer}

\item{format}{character string, "R", "R.expresion", "R.character", or
"LaTeX".}
}
\value{
a character string or an R expression.
}
\description{
Generate wavelength, wavenumber and wave frequency axis labels in SI units,
using SI scale factors. Output can be selected as character, expression (R
default devices) or LaTeX (for tikz device).
}
\examples{

w_length_label()
w_length_label("R.expression")
w_length_label("LaTeX")
w_number_label()
w_number_label("R.expression")
w_frequency_label()
w_frequency_label("R.expression")

}
