% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-wlength.R
\name{scale_x_frequency_continuous}
\alias{scale_x_frequency_continuous}
\title{Frequency x-scale}
\usage{
scale_x_frequency_continuous(
  unit.exponent = 12,
  name = w_frequency_label(unit.exponent = unit.exponent, label.text = label.text),
  breaks = scales::pretty_breaks(n = 7),
  labels = SI_pl_format(exponent = unit.exponent),
  label.text = axis_labels()[["freq"]],
  ...
)
}
\arguments{
\item{unit.exponent}{integer}

\item{name}{The name of the scale, used for the axis-label.}

\item{breaks}{The positions of ticks or a function to generate them.}

\item{labels}{The tick labels or a function to generate them from the tick
positions.}

\item{label.text}{character Textual portion of the labels.}

\item{...}{other named arguments passed to \code{scale_y_continuous}}
}
\description{
Scale x continuous with defaults suitable for wavelengths expressed as
frequencies [Hz].
}
\details{
This scale automates the generation of axis labels when the variable
  mapped to the \emph{x} aesthetic contains numeric values for wavelengths
  expressed as frequency. This is \strong{not} how spectral data are stored in
  the packages of the R for Photobiology suite and can be only used in plots
  built with \code{ggplot2()} with explicit mapping using a conversion
  function. If desired, a secondary axis can be added manually as described
  in \code{\link[ggplot2]{sec_axis}}.
}
\note{
This function only alters two default arguments, please, see
documentation for \code{\link[ggplot2]{scale_continuous}}
}
\examples{

ggplot(sun.spct, aes(x = wl2frequency(w.length), y = s.e.irrad)) +
  geom_line() +
  scale_x_frequency_continuous()

ggplot(sun.spct, aes(x = wl2frequency(w.length), y = s.e.irrad)) +
  geom_line() +
  scale_x_frequency_continuous(14)

}
