% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-spct.r
\name{geom_spct}
\alias{geom_spct}
\title{Spectral data plots.}
\usage{
geom_spct(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_string}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{na.rm}{If FALSE (the default), removes missing values with a warning.
If TRUE silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\description{
For each continuous x value, \code{geom_spct} displays a y interval.
\code{geom_spct} is a special case of \code{geom_area}, where the minimum of
the range is fixed to 0, but stacking is not enabled.
}
\details{
An spectrum plot is the analog of a line plot (see \code{\link{geom_line}}),
and can be used to show y varies over the range of x. The difference is that
the area under the line is filled.
}
\section{Aesthetics}{
 See \code{\link[ggplot2]{geom_ribbon}}
}
\examples{
library(ggplot2)
library(photobiology)
# ggplot() methods for spectral objects set a default mapping for x and y.
ggplot(sun.spct) + geom_spct()

}
\seealso{
\code{\link[ggplot2]{geom_area}} for stacked areas,
\code{\link[ggplot2]{geom_line}} for lines (lines),
\code{\link[ggplot2]{geom_point}} for scatter plots.
}

