% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renum.R
\name{renum}
\alias{renum}
\title{Pedigree renumbering}
\usage{
renum(ped)
}
\arguments{
\item{ped}{: \code{data.frame} with columns corresponding to ID, SIRE, DAM. Missing value is 0.}
}
\value{
newped : Pedigree \code{data.frame} with renumberred IDs.

xrf : Cross-reference \code{data.frame} with 2 columns for original and renumberred IDs.
}
\description{
Renumbering pedigree to numerical IDs, so that progeny's ID is smaller than parents' IDs.
}
\examples{
ped = data.frame(ID=letters[1:6], SIRE=c(0,0,letters[c(1,3,1,4)]), DAM=c(0,0,letters[c(2,2,2,5)]))
renum(ped)

}
