% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-boxplot-jitter.R
\name{geom_boxplot_jitter}
\alias{geom_boxplot_jitter}
\title{This geom is similar to \code{\link[ggplot2]{geom_boxplot}}, but allows to jitter outlier points and to raster points layer.}
\usage{
geom_boxplot_jitter(
  mapping = NULL,
  data = NULL,
  stat = "boxplot",
  position = "dodge",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...,
  outlier.jitter.width = NULL,
  outlier.jitter.height = 0,
  raster.dpi = 300
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{Use to override the default connection between
\code{geom_boxplot} and \code{stat_boxplot}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{outlier.jitter.width}{Amount of horizontal jitter. The jitter is added in both positive and negative directions,
so the total spread is twice the value specified here. Default: boxplot width.}

\item{outlier.jitter.height}{Amount of horizontal jitter. The jitter is added in both positive and negative directions,
so the total spread is twice the value specified here. Default: 0.}

\item{raster.dpi}{Resolution of the rastered image. Ignored if \code{raster == FALSE}.}
}
\value{
geom_boxplot plot with rasterized layer
}
\description{
This geom is similar to \code{\link[ggplot2]{geom_boxplot}}, but allows to jitter outlier points and to raster points layer.
}
\section{Aesthetics}{


\code{geom_boxplot()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{x} \emph{or} \code{y}}
\item \strong{\code{lower} \emph{or} \code{xlower}}
\item \strong{\code{upper} \emph{or} \code{xupper}}
\item \strong{\code{middle} \emph{or} \code{xmiddle}}
\item \strong{\code{ymin} \emph{or} \code{xmin}}
\item \strong{\code{ymax} \emph{or} \code{xmax}}
\item \code{alpha}
\item \code{colour}
\item \code{fill}
\item \code{group}
\item \code{linetype}
\item \code{shape}
\item \code{size}
\item \code{weight}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.

}

\examples{
library(ggplot2)
library(ggrastr)

yvalues = rt(1000, df=3)
xvalues = as.factor(1:1000 \%\% 2)
ggplot() + geom_boxplot_jitter(aes(y=yvalues, x=xvalues), outlier.jitter.width = 0.1, raster = TRUE)

}
