% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-nudge-stack.R
\name{position_stacknudge}
\alias{position_stacknudge}
\alias{position_fillnudge}
\alias{position_stack_keep}
\alias{position_fill_keep}
\title{Combined positions stack and nudge}
\source{
\url{https://github.com/slowkow/ggrepel/issues/161}.
}
\usage{
position_stacknudge(
  vjust = 1,
  reverse = FALSE,
  x = 0,
  y = 0,
  direction = "none",
  kept.origin = "stacked"
)

position_fillnudge(
  vjust = 1,
  reverse = FALSE,
  x = 0,
  y = 0,
  direction = "none",
  kept.origin = "stacked"
)

position_stack_keep(vjust = 1, reverse = FALSE)

position_fill_keep(vjust = 1, reverse = FALSE)
}
\arguments{
\item{vjust}{Vertical adjustment for geoms that have a position (like points
or lines), not a dimension (like bars or areas). Set to 0 to align with the
bottom, 0.5 for the middle, and 1 (the default) for the top.}

\item{reverse}{If TRUE, will reverse the default stacking order. This is
useful if you're rotating both the plot and legend.}

\item{x, y}{Amount of vertical and horizontal distance to move. A numeric
vector of length 1, or of the same length as rows there are in \code{data},}

\item{direction}{One of \code{"none"}, \code{"split"}, \code{"split.x"} or
\code{"split.y"}. A value of \code{"none"} replicates the behavior of
\code{\link[ggplot2]{position_nudge}}. At the moment \code{"split"} changes
the sign of the nudge at zero, which is suitable for column plots with
negative slices.}

\item{kept.origin}{One of \code{"original"}, \code{"stacked"} or
\code{"none"}.}
}
\value{
A \code{"Position"} object.
}
\description{
\code{position_stacknudge()} is useful when labelling plots such as stacked
bars, stacked columns, stacked lines, etc. In contrast to
\code{\link[ggplot2]{position_nudge}}, \code{position_stacknudge()} returns
in \code{data} both the original coordinates and the nudged coordinates.
}
\details{
This position function is backwards compatible with
\code{\link[ggplot2]{position_nudge}} but extends it by adding support for
stacking and for geometries that make use of the original position to draw
connecting segments or arrows.

The wrapper \code{position_nudge_keep()} with exactly the same signature and
behaviour as \code{\link[ggplot2]{position_nudge}} provides an easier to
remember name when the desire is only to have access to both the original and
nudged coordinates.
}
\examples{

df <- data.frame(x1 = c("a", "a", "b", "b", "b"),
                 x2 = c(1, 2, 1, 3, -1),
                 grp = c("some long name", "other name", "some name",
                         "another name", "some long name"))

# Add labels to a horizontal column plot (stacked by default)
ggplot(data = df, aes(x1, x2, group = grp)) +
  geom_col(aes(fill = grp), width=0.5) +
  geom_vline(xintercept = 0) +
  geom_text(
    aes(label = grp),
    position = position_stacknudge(vjust = 0.5, y = 0.3)) +
  theme(legend.position = "none")

# Add labels to a vertical column plot (stacked by default)
ggplot(data = df, aes(x2, x1, group = grp)) +
  geom_col(aes(fill = grp), width=0.5) +
  geom_vline(xintercept = 0) +
  geom_text(
    aes(label = grp),
    position = position_stacknudge(vjust = 0.5, x = -0.3),
    angle = 90) +
  theme(legend.position = "none")

# Add labels to a vertical column plot (stacked by default)
ggplot(data = subset(df, x1 >= 0), aes(x1, x2, group = grp)) +
  geom_col(aes(fill = grp), width=0.5, position = position_fill()) +
  geom_vline(xintercept = 0) +
  geom_text(
    aes(label = grp),
    position = position_fillnudge(vjust = 0.5, x = -0.3),
    angle = 90) +
  theme(legend.position = "none")

# Add label at a fixed distance from the top of each column slice
ggplot(data = df, aes(x1, x2, group = grp)) +
  geom_col(aes(fill = grp), width=0.5) +
  geom_vline(xintercept = 0) +
  geom_text(
    aes(label = grp),
    position = position_stacknudge(vjust = 1, y = -0.2)) +
  theme(legend.position = "none")

# Use geom_text_s(), geom_text_repel() or geom_label_repel() to link
# label to labelled segment or object with an arrow
ggplot(data = df, aes(x2, x1, group = grp)) +
  geom_col(aes(fill = grp), width=0.5) +
  geom_vline(xintercept = 0) +
  geom_text_s(
    aes(label = grp),
    position = position_stacknudge(vjust = 0.5, y = 0.35),
    vjust = "bottom") +
  theme(legend.position = "none")

}
\seealso{
\code{\link[ggplot2]{position_nudge}},
  \code{\link[ggplot2]{position_stack}},
  \code{\link[ggrepel]{position_nudge_repel}}.

Other position adjustments: 
\code{\link{position_dodgenudge}()},
\code{\link{position_jitternudge}()},
\code{\link{position_nudge_center}()},
\code{\link{position_nudge_line}()},
\code{\link{position_nudge_to}()}
}
\author{
Michał Krassowski, edited by Pedro J. Aphalo.
}
\concept{position adjustments}
