% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.r
\name{merge_element}
\alias{merge_element}
\alias{merge_element.default}
\alias{merge_element.element_blank}
\alias{merge_element.element}
\title{Merge a parent element into a child element}
\usage{
merge_element(new, old)

\method{merge_element}{default}(new, old)

\method{merge_element}{element_blank}(new, old)

\method{merge_element}{element}(new, old)
}
\arguments{
\item{new}{The child element in the theme hierarchy}

\item{old}{The parent element in the theme hierarchy}
}
\value{
A modified version of \code{new} updated with the properties of
\code{old}
}
\description{
This is a generic and element classes must provide an implementation of this
method
}
\examples{
new <- element_text(colour = "red")
old <- element_text(colour = "blue", size = 10)

# Adopt size but ignore colour
merge_element(new, old)

}
\keyword{internal}
