% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_errorbar.R
\name{pathway_errorbar}
\alias{pathway_errorbar}
\title{The function pathway_errorbar() is used to visualize the results of functional pathway differential abundance analysis as error bar plots.}
\arguments{
\item{abundance}{A data frame with row names representing pathways and column names representing samples. Each element represents the relative abundance of the corresponding pathway in the corresponding sample.}

\item{daa_results_df}{A data frame containing the results of the differential abundance analysis of the pathways, generated by the pathway_daa function. x_lab should be a column name of daa_results_df.}

\item{Group}{A data frame or a vector that assigns each sample to a group. The groups are used to color the samples in the figure.}

\item{ko_to_kegg}{A logical parameter indicating whether there was a convertion that convert ko abundance to kegg abundance.}

\item{p_values_threshold}{A numeric parameter specifying the threshold for statistical significance of differential abundance. Pathways with p-values below this threshold will be considered significant.}

\item{order}{A parameter controlling the ordering of the rows in the figure. The options are: "p_values" (order by p-values), "name" (order by pathway name), "group" (order by the group with the highest mean relative abundance), or "pathway_class" (order by the pathway category).}

\item{select}{A vector of pathway names to be included in the figure. This can be used to limit the number of pathways displayed. If NULL, all pathways will be displayed.}

\item{p_value_bar}{A logical parameter indicating whether to display a bar showing the p-value threshold for significance. If TRUE, the bar will be displayed.}

\item{colors}{A vector of colors to be used to represent the groups in the figure. Each color corresponds to a group.}

\item{x_lab}{A character string to be used as the x-axis label in the figure. The default value is "description" for KOs'descriptions and "pathway_name" for KEGG pathway names.}
}
\value{
A figure showing the error bar plot of the differential abundance analysis results for the functional pathways.
}
\description{
The function pathway_errorbar() is used to visualize the results of functional pathway differential abundance analysis as error bar plots.
}
\examples{
\dontrun{
# Example 1: Analyzing KEGG pathway abundance
metadata <- read_delim(
  "~/Microbiome/C9orf72/Code And Data/new_metadata.txt",
  delim = "\t",
  escape_double = FALSE,
  trim_ws = TRUE
)

kegg_abundance <- ko2kegg_abundance(
  "/Users/apple/Downloads/
  pred_metagenome_unstrat.tsv/pred_metagenome_unstrat.tsv"
)

daa_results_df <- pathway_daa(
  abundance = kegg_abundance,
  metadata = metadata,
  group = group,
  daa_method = "ALDEx2",
  select = NULL,
  reference = NULL
)

daa_sub_method_results_df <- daa_results_df[daa_results_df$method
== "ALDEx2_Kruskal-Wallace test", ]

daa_annotated_sub_method_results_df <- pathway_annotation(
  pathway = "KO",
  daa_results_df = daa_sub_method_results_df,
  ko_to_kegg = TRUE
)

Group <- metadata$Enviroment

daa_results_list <- pathway_errorbar(
  abundance = kegg_abundance,
  daa_results_df = daa_annotated_sub_method_results_df,
  Group = Group,
  p_values_threshold = 0.05,
  order = "pathway_class",
  select = NULL,
  ko_to_kegg = TRUE,
  p_value_bar = TRUE,
  colors = NULL,
  x_lab = "pathway_name"
)

# Example 2: Analyzing EC, MetaCyc, KO without conversions
metadata <- read_delim(
  "~/Microbiome/C9orf72/Code And Data/new_metadata.txt",
  delim = "\t",
  escape_double = FALSE,
  trim_ws = TRUE
)

ko_abundance <- read.delim("/Users/apple/Downloads/
pred_metagenome_unstrat.tsv/pred_metagenome_unstrat.tsv")

daa_results_df <- pathway_daa(
  abundance = ko_abundance,
  metadata = metadata,
  group = group,
  daa_method = "ALDEx2",
  select = NULL,
  reference = NULL
)

daa_sub_method_results_df <- daa_results_df[daa_results_df$method
== "ALDEx2_Kruskal-Wallace test", ]

daa_annotated_sub_method_results_df <- pathway_annotation(
  pathway = "KO",
  daa_results_df = daa_sub_method_results_df,
  ko_to_kegg = FALSE
)

Group <- metadata$Enviroment

daa_results_list <- pathway_errorbar(
  abundance = ko_abundance,
  daa_results_df = daa_annotated_sub_method_results_df,
  Group = Group,
  p_values_threshold = 0.05,
  order = "pathway_class",
  select = NULL,
  ko_to_kegg = FALSE,
  p_value_bar = TRUE,
  colors = NULL,
  x_lab = "description"
)
}
}
